/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshallers;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.core.util.UriResourcePathUtils;
import software.amazon.awssdk.services.s3.model.ListMultipartUploadsRequest;

public class ListMultipartUploadsRequestMarshaller
implements Marshaller<Request<ListMultipartUploadsRequest>, ListMultipartUploadsRequest> {
    public Request<ListMultipartUploadsRequest> marshall(ListMultipartUploadsRequest listMultipartUploadsRequest) {
        if (listMultipartUploadsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listMultipartUploadsRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/{Bucket}?uploads";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParametersToRequest((Request)request, (String)uriResourcePath);
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", listMultipartUploadsRequest.bucket());
        request.setResourcePath(uriResourcePath);
        if (listMultipartUploadsRequest.delimiter() != null) {
            request.addParameter("delimiter", StringUtils.fromString((String)listMultipartUploadsRequest.delimiter()));
        }
        if (listMultipartUploadsRequest.encodingTypeString() != null) {
            request.addParameter("encoding-type", StringUtils.fromString((String)listMultipartUploadsRequest.encodingTypeString()));
        }
        if (listMultipartUploadsRequest.keyMarker() != null) {
            request.addParameter("key-marker", StringUtils.fromString((String)listMultipartUploadsRequest.keyMarker()));
        }
        if (listMultipartUploadsRequest.maxUploads() != null) {
            request.addParameter("max-uploads", StringUtils.fromInteger((Integer)listMultipartUploadsRequest.maxUploads()));
        }
        if (listMultipartUploadsRequest.prefix() != null) {
            request.addParameter("prefix", StringUtils.fromString((String)listMultipartUploadsRequest.prefix()));
        }
        if (listMultipartUploadsRequest.uploadIdMarker() != null) {
            request.addParameter("upload-id-marker", StringUtils.fromString((String)listMultipartUploadsRequest.uploadIdMarker()));
        }
        return request;
    }
}

