/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.DeletedObject;

public class DeletedObjectUnmarshaller
implements Unmarshaller<DeletedObject, StaxUnmarshallerContext> {
    private static final DeletedObjectUnmarshaller INSTANCE = new DeletedObjectUnmarshaller();

    public DeletedObject unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        DeletedObject.Builder deletedObject = DeletedObject.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Key", targetDepth)) {
                    deletedObject.key(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("VersionId", targetDepth)) {
                    deletedObject.versionId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DeleteMarker", targetDepth)) {
                    deletedObject.deleteMarker(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("DeleteMarkerVersionId", targetDepth)) continue;
                deletedObject.deleteMarkerVersionId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (DeletedObject)deletedObject.build();
    }

    public static DeletedObjectUnmarshaller getInstance() {
        return INSTANCE;
    }
}

