/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.AnalyticsFilter;
import software.amazon.awssdk.services.s3.transform.AnalyticsAndOperatorUnmarshaller;
import software.amazon.awssdk.services.s3.transform.TagUnmarshaller;

public class AnalyticsFilterUnmarshaller
implements Unmarshaller<AnalyticsFilter, StaxUnmarshallerContext> {
    private static final AnalyticsFilterUnmarshaller INSTANCE = new AnalyticsFilterUnmarshaller();

    public AnalyticsFilter unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        AnalyticsFilter.Builder analyticsFilter = AnalyticsFilter.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Prefix", targetDepth)) {
                    analyticsFilter.prefix(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Tag", targetDepth)) {
                    analyticsFilter.tag(TagUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("And", targetDepth)) continue;
                analyticsFilter.and(AnalyticsAndOperatorUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (AnalyticsFilter)analyticsFilter.build();
    }

    public static AnalyticsFilterUnmarshaller getInstance() {
        return INSTANCE;
    }
}

