/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Optional;
import software.amazon.awssdk.services.s3.model.TransitionStorageClass;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class NoncurrentVersionTransition
implements ToCopyableBuilder<Builder, NoncurrentVersionTransition> {
    private final Integer noncurrentDays;
    private final String storageClass;

    private NoncurrentVersionTransition(BuilderImpl builder) {
        this.noncurrentDays = builder.noncurrentDays;
        this.storageClass = builder.storageClass;
    }

    public Integer noncurrentDays() {
        return this.noncurrentDays;
    }

    public TransitionStorageClass storageClass() {
        return TransitionStorageClass.fromValue(this.storageClass);
    }

    public String storageClassString() {
        return this.storageClass;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.noncurrentDays() == null ? 0 : this.noncurrentDays().hashCode());
        hashCode = 31 * hashCode + (this.storageClassString() == null ? 0 : this.storageClassString().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NoncurrentVersionTransition)) {
            return false;
        }
        NoncurrentVersionTransition other = (NoncurrentVersionTransition)obj;
        if (other.noncurrentDays() == null ^ this.noncurrentDays() == null) {
            return false;
        }
        if (other.noncurrentDays() != null && !other.noncurrentDays().equals(this.noncurrentDays())) {
            return false;
        }
        if (other.storageClassString() == null ^ this.storageClassString() == null) {
            return false;
        }
        return other.storageClassString() == null || other.storageClassString().equals(this.storageClassString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.noncurrentDays() != null) {
            sb.append("NoncurrentDays: ").append(this.noncurrentDays()).append(",");
        }
        if (this.storageClassString() != null) {
            sb.append("StorageClass: ").append(this.storageClassString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NoncurrentDays": {
                return Optional.of(clazz.cast(this.noncurrentDays()));
            }
            case "StorageClass": {
                return Optional.of(clazz.cast(this.storageClassString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Integer noncurrentDays;
        private String storageClass;

        private BuilderImpl() {
        }

        private BuilderImpl(NoncurrentVersionTransition model) {
            this.noncurrentDays(model.noncurrentDays);
            this.storageClass(model.storageClass);
        }

        public final Integer getNoncurrentDays() {
            return this.noncurrentDays;
        }

        @Override
        public final Builder noncurrentDays(Integer noncurrentDays) {
            this.noncurrentDays = noncurrentDays;
            return this;
        }

        public final void setNoncurrentDays(Integer noncurrentDays) {
            this.noncurrentDays = noncurrentDays;
        }

        public final String getStorageClass() {
            return this.storageClass;
        }

        @Override
        public final Builder storageClass(String storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        @Override
        public final Builder storageClass(TransitionStorageClass storageClass) {
            this.storageClass(storageClass.toString());
            return this;
        }

        public final void setStorageClass(String storageClass) {
            this.storageClass = storageClass;
        }

        public NoncurrentVersionTransition build() {
            return new NoncurrentVersionTransition(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, NoncurrentVersionTransition> {
        public Builder noncurrentDays(Integer var1);

        public Builder storageClass(String var1);

        public Builder storageClass(TransitionStorageClass var1);
    }
}

