/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.VersioningConfiguration;

public class VersioningConfigurationUnmarshaller
implements Unmarshaller<VersioningConfiguration, StaxUnmarshallerContext> {
    private static final VersioningConfigurationUnmarshaller INSTANCE = new VersioningConfigurationUnmarshaller();

    public VersioningConfiguration unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        VersioningConfiguration.Builder versioningConfiguration = VersioningConfiguration.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("MfaDelete", targetDepth)) {
                    versioningConfiguration.mfaDelete(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Status", targetDepth)) continue;
                versioningConfiguration.status(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (VersioningConfiguration)versioningConfiguration.build();
    }

    public static VersioningConfigurationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

