/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.S3Error;

public class S3ErrorUnmarshaller
implements Unmarshaller<S3Error, StaxUnmarshallerContext> {
    private static final S3ErrorUnmarshaller INSTANCE = new S3ErrorUnmarshaller();

    public S3Error unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        S3Error.Builder s3Error = S3Error.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Key", targetDepth)) {
                    s3Error.key(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("VersionId", targetDepth)) {
                    s3Error.versionId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Code", targetDepth)) {
                    s3Error.code(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Message", targetDepth)) continue;
                s3Error.message(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (S3Error)s3Error.build();
    }

    public static S3ErrorUnmarshaller getInstance() {
        return INSTANCE;
    }
}

