/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.RestoreObjectResponse;

public class RestoreObjectResponseUnmarshaller
implements Unmarshaller<RestoreObjectResponse, StaxUnmarshallerContext> {
    private static final RestoreObjectResponseUnmarshaller INSTANCE = new RestoreObjectResponseUnmarshaller();

    public RestoreObjectResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        RestoreObjectResponse.Builder restoreObjectResponse = RestoreObjectResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        if (context.isStartOfDocument()) {
            context.setCurrentHeader("x-amz-request-charged");
            restoreObjectResponse.requestCharged(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
        }
        return (RestoreObjectResponse)((Object)restoreObjectResponse.build());
    }

    public static RestoreObjectResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}

