/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.PathMarshallers;
import software.amazon.awssdk.services.s3.model.AccelerateConfiguration;
import software.amazon.awssdk.services.s3.model.PutBucketAccelerateConfigurationRequest;
import software.amazon.awssdk.util.Md5Utils;
import software.amazon.awssdk.util.StringInputStream;
import software.amazon.awssdk.util.StringUtils;
import software.amazon.awssdk.util.UriResourcePathUtils;
import software.amazon.awssdk.util.XmlWriter;

public class PutBucketAccelerateConfigurationRequestMarshaller
implements Marshaller<Request<PutBucketAccelerateConfigurationRequest>, PutBucketAccelerateConfigurationRequest> {
    public Request<PutBucketAccelerateConfigurationRequest> marshall(PutBucketAccelerateConfigurationRequest putBucketAccelerateConfigurationRequest) {
        if (putBucketAccelerateConfigurationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putBucketAccelerateConfigurationRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.PUT);
        String uriResourcePath = "/{Bucket}?accelerate";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParamtersToRequest((Request)request, (String)uriResourcePath);
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", putBucketAccelerateConfigurationRequest.bucket());
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = null;
            AccelerateConfiguration accelerateConfiguration = putBucketAccelerateConfigurationRequest.accelerateConfiguration();
            if (accelerateConfiguration != null) {
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter((Writer)stringWriter, "http://s3.amazonaws.com/doc/2006-03-01/");
                xmlWriter.startElement("AccelerateConfiguration");
                if (accelerateConfiguration.status() != null) {
                    xmlWriter.startElement("Status").value(accelerateConfiguration.status()).endElement();
                }
                xmlWriter.endElement();
            }
            if (stringWriter != null) {
                if (!request.getHeaders().containsKey("Content-MD5")) {
                    request.addHeader("Content-MD5", Md5Utils.md5AsBase64((byte[])stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8)));
                }
                request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

