/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.Owner;

public class OwnerUnmarshaller
implements Unmarshaller<Owner, StaxUnmarshallerContext> {
    private static final OwnerUnmarshaller INSTANCE = new OwnerUnmarshaller();

    public Owner unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        Owner.Builder owner = Owner.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("DisplayName", targetDepth)) {
                    owner.displayName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("ID", targetDepth)) continue;
                owner.id(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (Owner)owner.build();
    }

    public static OwnerUnmarshaller getInstance() {
        return INSTANCE;
    }
}

