/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.CommonPrefix;
import software.amazon.awssdk.services.s3.model.ListMultipartUploadsResponse;
import software.amazon.awssdk.services.s3.model.MultipartUpload;
import software.amazon.awssdk.services.s3.transform.CommonPrefixUnmarshaller;
import software.amazon.awssdk.services.s3.transform.MultipartUploadUnmarshaller;

public class ListMultipartUploadsResponseUnmarshaller
implements Unmarshaller<ListMultipartUploadsResponse, StaxUnmarshallerContext> {
    private static final ListMultipartUploadsResponseUnmarshaller INSTANCE = new ListMultipartUploadsResponseUnmarshaller();

    public ListMultipartUploadsResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        ListMultipartUploadsResponse.Builder listMultipartUploadsResponse;
        block17: {
            listMultipartUploadsResponse = ListMultipartUploadsResponse.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<MultipartUpload> uploads = null;
            ArrayList<CommonPrefix> commonPrefixes = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    listMultipartUploadsResponse.uploads(uploads);
                    listMultipartUploadsResponse.commonPrefixes(commonPrefixes);
                    break block17;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("Bucket", targetDepth)) {
                        listMultipartUploadsResponse.bucket(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("KeyMarker", targetDepth)) {
                        listMultipartUploadsResponse.keyMarker(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("UploadIdMarker", targetDepth)) {
                        listMultipartUploadsResponse.uploadIdMarker(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("NextKeyMarker", targetDepth)) {
                        listMultipartUploadsResponse.nextKeyMarker(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Prefix", targetDepth)) {
                        listMultipartUploadsResponse.prefix(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Delimiter", targetDepth)) {
                        listMultipartUploadsResponse.delimiter(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("NextUploadIdMarker", targetDepth)) {
                        listMultipartUploadsResponse.nextUploadIdMarker(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("MaxUploads", targetDepth)) {
                        listMultipartUploadsResponse.maxUploads(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("IsTruncated", targetDepth)) {
                        listMultipartUploadsResponse.isTruncated(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Upload", targetDepth)) {
                        if (uploads == null) {
                            uploads = new ArrayList<MultipartUpload>();
                        }
                        uploads.add(MultipartUploadUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("CommonPrefixes", targetDepth)) {
                        if (commonPrefixes == null) {
                            commonPrefixes = new ArrayList<CommonPrefix>();
                        }
                        commonPrefixes.add(CommonPrefixUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("EncodingType", targetDepth)) continue;
                    listMultipartUploadsResponse.encodingType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            listMultipartUploadsResponse.uploads(uploads);
            listMultipartUploadsResponse.commonPrefixes(commonPrefixes);
        }
        return (ListMultipartUploadsResponse)((Object)listMultipartUploadsResponse.build());
    }

    public static ListMultipartUploadsResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}

