/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.Initiator;

public class InitiatorUnmarshaller
implements Unmarshaller<Initiator, StaxUnmarshallerContext> {
    private static final InitiatorUnmarshaller INSTANCE = new InitiatorUnmarshaller();

    public Initiator unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        Initiator.Builder initiator = Initiator.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("ID", targetDepth)) {
                    initiator.id(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("DisplayName", targetDepth)) continue;
                initiator.displayName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (Initiator)initiator.build();
    }

    public static InitiatorUnmarshaller getInstance() {
        return INSTANCE;
    }
}

