/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.MapEntry;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.util.DateUtils;

public class GetObjectResponseUnmarshaller
implements Unmarshaller<GetObjectResponse, StaxUnmarshallerContext> {
    private static final GetObjectResponseUnmarshaller INSTANCE = new GetObjectResponseUnmarshaller();

    public GetObjectResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        GetObjectResponse.Builder getObjectResponse = GetObjectResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            context.setCurrentHeader("x-amz-delete-marker");
            getObjectResponse.deleteMarker(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("accept-ranges");
            getObjectResponse.acceptRanges(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("x-amz-expiration");
            getObjectResponse.expiration(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("x-amz-restore");
            getObjectResponse.restore(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("Last-Modified");
            getObjectResponse.lastModified(DateUtils.parseRfc1123Date((String)context.readText()));
            context.setCurrentHeader("Content-Length");
            getObjectResponse.contentLength(SimpleTypeStaxUnmarshallers.LongUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("ETag");
            getObjectResponse.eTag(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("x-amz-missing-meta");
            getObjectResponse.missingMeta(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("x-amz-version-id");
            getObjectResponse.versionId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("Cache-Control");
            getObjectResponse.cacheControl(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("Content-Disposition");
            getObjectResponse.contentDisposition(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("Content-Encoding");
            getObjectResponse.contentEncoding(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("Content-Language");
            getObjectResponse.contentLanguage(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("Content-Range");
            getObjectResponse.contentRange(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("Content-Type");
            getObjectResponse.contentType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("Expires");
            getObjectResponse.expires(DateUtils.parseRfc1123Date((String)context.readText()));
            context.setCurrentHeader("x-amz-website-redirect-location");
            getObjectResponse.websiteRedirectLocation(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("x-amz-server-side-encryption");
            getObjectResponse.serverSideEncryption(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("x-amz-server-side-encryption-customer-algorithm");
            getObjectResponse.sseCustomerAlgorithm(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("x-amz-server-side-encryption-customer-key-MD5");
            getObjectResponse.sseCustomerKeyMD5(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("x-amz-server-side-encryption-aws-kms-key-id");
            getObjectResponse.ssekmsKeyId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("x-amz-storage-class");
            getObjectResponse.storageClass(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("x-amz-request-charged");
            getObjectResponse.requestCharged(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("x-amz-replication-status");
            getObjectResponse.replicationStatus(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("x-amz-mp-parts-count");
            getObjectResponse.partsCount(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("x-amz-tagging-count");
            getObjectResponse.tagCount(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
        }
        HashMap<String, String> metadata = new HashMap<String, String>();
        context.getHeaders().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("x-amz-meta-")).forEach(e -> metadata.put(((String)e.getKey()).replace("x-amz-meta-", ""), (String)e.getValue()));
        getObjectResponse.metadata(metadata);
        return (GetObjectResponse)((Object)getObjectResponse.build());
    }

    public static GetObjectResponseUnmarshaller getInstance() {
        return INSTANCE;
    }

    private static class MetadataMapEntryUnmarshaller
    implements Unmarshaller<Map.Entry<String, String>, StaxUnmarshallerContext> {
        private static final MetadataMapEntryUnmarshaller INSTANCE = new MetadataMapEntryUnmarshaller();

        private MetadataMapEntryUnmarshaller() {
        }

        public Map.Entry<String, String> unmarshall(StaxUnmarshallerContext context) throws Exception {
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            MapEntry entry = new MapEntry();
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    return entry;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("key", targetDepth)) {
                        entry.setKey((Object)SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("value", targetDepth)) continue;
                    entry.setValue((Object)SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            return entry;
        }

        public static MetadataMapEntryUnmarshaller getInstance() {
            return INSTANCE;
        }
    }
}

