/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.DeleteMarkerEntry;
import software.amazon.awssdk.services.s3.transform.OwnerUnmarshaller;

public class DeleteMarkerEntryUnmarshaller
implements Unmarshaller<DeleteMarkerEntry, StaxUnmarshallerContext> {
    private static final DeleteMarkerEntryUnmarshaller INSTANCE = new DeleteMarkerEntryUnmarshaller();

    public DeleteMarkerEntry unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        DeleteMarkerEntry.Builder deleteMarkerEntry = DeleteMarkerEntry.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Owner", targetDepth)) {
                    deleteMarkerEntry.owner(OwnerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Key", targetDepth)) {
                    deleteMarkerEntry.key(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("VersionId", targetDepth)) {
                    deleteMarkerEntry.versionId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("IsLatest", targetDepth)) {
                    deleteMarkerEntry.isLatest(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("LastModified", targetDepth)) continue;
                deleteMarkerEntry.lastModified(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (DeleteMarkerEntry)deleteMarkerEntry.build();
    }

    public static DeleteMarkerEntryUnmarshaller getInstance() {
        return INSTANCE;
    }
}

