/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.AnalyticsConfiguration;
import software.amazon.awssdk.services.s3.transform.AnalyticsFilterUnmarshaller;
import software.amazon.awssdk.services.s3.transform.StorageClassAnalysisUnmarshaller;

public class AnalyticsConfigurationUnmarshaller
implements Unmarshaller<AnalyticsConfiguration, StaxUnmarshallerContext> {
    private static final AnalyticsConfigurationUnmarshaller INSTANCE = new AnalyticsConfigurationUnmarshaller();

    public AnalyticsConfiguration unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        AnalyticsConfiguration.Builder analyticsConfiguration = AnalyticsConfiguration.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Id", targetDepth)) {
                    analyticsConfiguration.id(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Filter", targetDepth)) {
                    analyticsConfiguration.filter(AnalyticsFilterUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("StorageClassAnalysis", targetDepth)) continue;
                analyticsConfiguration.storageClassAnalysis(StorageClassAnalysisUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (AnalyticsConfiguration)analyticsConfiguration.build();
    }

    public static AnalyticsConfigurationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

