/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.time.Instant;
import software.amazon.awssdk.services.s3.model.TransitionStorageClass;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Transition
implements ToCopyableBuilder<Builder, Transition> {
    private final Instant dateValue;
    private final Integer days;
    private final String storageClass;

    private Transition(BuilderImpl builder) {
        this.dateValue = builder.dateValue;
        this.days = builder.days;
        this.storageClass = builder.storageClass;
    }

    public Instant date() {
        return this.dateValue;
    }

    public Integer days() {
        return this.days;
    }

    public String storageClass() {
        return this.storageClass;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.date() == null ? 0 : this.date().hashCode());
        hashCode = 31 * hashCode + (this.days() == null ? 0 : this.days().hashCode());
        hashCode = 31 * hashCode + (this.storageClass() == null ? 0 : this.storageClass().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Transition)) {
            return false;
        }
        Transition other = (Transition)obj;
        if (other.date() == null ^ this.date() == null) {
            return false;
        }
        if (other.date() != null && !other.date().equals(this.date())) {
            return false;
        }
        if (other.days() == null ^ this.days() == null) {
            return false;
        }
        if (other.days() != null && !other.days().equals(this.days())) {
            return false;
        }
        if (other.storageClass() == null ^ this.storageClass() == null) {
            return false;
        }
        return other.storageClass() == null || other.storageClass().equals(this.storageClass());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.date() != null) {
            sb.append("Date: ").append(this.date()).append(",");
        }
        if (this.days() != null) {
            sb.append("Days: ").append(this.days()).append(",");
        }
        if (this.storageClass() != null) {
            sb.append("StorageClass: ").append(this.storageClass()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Instant dateValue;
        private Integer days;
        private String storageClass;

        private BuilderImpl() {
        }

        private BuilderImpl(Transition model) {
            this.setDate(model.dateValue);
            this.setDays(model.days);
            this.setStorageClass(model.storageClass);
        }

        public final Instant getDate() {
            return this.dateValue;
        }

        @Override
        public final Builder date(Instant dateValue) {
            this.dateValue = dateValue;
            return this;
        }

        public final void setDate(Instant dateValue) {
            this.dateValue = dateValue;
        }

        public final Integer getDays() {
            return this.days;
        }

        @Override
        public final Builder days(Integer days) {
            this.days = days;
            return this;
        }

        public final void setDays(Integer days) {
            this.days = days;
        }

        public final String getStorageClass() {
            return this.storageClass;
        }

        @Override
        public final Builder storageClass(String storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        @Override
        public final Builder storageClass(TransitionStorageClass storageClass) {
            this.storageClass(storageClass.toString());
            return this;
        }

        public final void setStorageClass(String storageClass) {
            this.storageClass = storageClass;
        }

        public Transition build() {
            return new Transition(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Transition> {
        public Builder date(Instant var1);

        public Builder days(Integer var1);

        public Builder storageClass(String var1);

        public Builder storageClass(TransitionStorageClass var1);
    }
}

