/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.s3.model.AccessControlPolicy;
import software.amazon.awssdk.services.s3.model.ObjectCannedACL;
import software.amazon.awssdk.services.s3.model.RequestPayer;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutObjectAclRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, PutObjectAclRequest> {
    private final String acl;
    private final AccessControlPolicy accessControlPolicy;
    private final String bucket;
    private final String contentMD5;
    private final String grantFullControl;
    private final String grantRead;
    private final String grantReadACP;
    private final String grantWrite;
    private final String grantWriteACP;
    private final String key;
    private final String requestPayer;
    private final String versionId;

    private PutObjectAclRequest(BuilderImpl builder) {
        this.acl = builder.acl;
        this.accessControlPolicy = builder.accessControlPolicy;
        this.bucket = builder.bucket;
        this.contentMD5 = builder.contentMD5;
        this.grantFullControl = builder.grantFullControl;
        this.grantRead = builder.grantRead;
        this.grantReadACP = builder.grantReadACP;
        this.grantWrite = builder.grantWrite;
        this.grantWriteACP = builder.grantWriteACP;
        this.key = builder.key;
        this.requestPayer = builder.requestPayer;
        this.versionId = builder.versionId;
    }

    public String acl() {
        return this.acl;
    }

    public AccessControlPolicy accessControlPolicy() {
        return this.accessControlPolicy;
    }

    public String bucket() {
        return this.bucket;
    }

    public String contentMD5() {
        return this.contentMD5;
    }

    public String grantFullControl() {
        return this.grantFullControl;
    }

    public String grantRead() {
        return this.grantRead;
    }

    public String grantReadACP() {
        return this.grantReadACP;
    }

    public String grantWrite() {
        return this.grantWrite;
    }

    public String grantWriteACP() {
        return this.grantWriteACP;
    }

    public String key() {
        return this.key;
    }

    public String requestPayer() {
        return this.requestPayer;
    }

    public String versionId() {
        return this.versionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.acl() == null ? 0 : this.acl().hashCode());
        hashCode = 31 * hashCode + (this.accessControlPolicy() == null ? 0 : this.accessControlPolicy().hashCode());
        hashCode = 31 * hashCode + (this.bucket() == null ? 0 : this.bucket().hashCode());
        hashCode = 31 * hashCode + (this.contentMD5() == null ? 0 : this.contentMD5().hashCode());
        hashCode = 31 * hashCode + (this.grantFullControl() == null ? 0 : this.grantFullControl().hashCode());
        hashCode = 31 * hashCode + (this.grantRead() == null ? 0 : this.grantRead().hashCode());
        hashCode = 31 * hashCode + (this.grantReadACP() == null ? 0 : this.grantReadACP().hashCode());
        hashCode = 31 * hashCode + (this.grantWrite() == null ? 0 : this.grantWrite().hashCode());
        hashCode = 31 * hashCode + (this.grantWriteACP() == null ? 0 : this.grantWriteACP().hashCode());
        hashCode = 31 * hashCode + (this.key() == null ? 0 : this.key().hashCode());
        hashCode = 31 * hashCode + (this.requestPayer() == null ? 0 : this.requestPayer().hashCode());
        hashCode = 31 * hashCode + (this.versionId() == null ? 0 : this.versionId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutObjectAclRequest)) {
            return false;
        }
        PutObjectAclRequest other = (PutObjectAclRequest)((Object)obj);
        if (other.acl() == null ^ this.acl() == null) {
            return false;
        }
        if (other.acl() != null && !other.acl().equals(this.acl())) {
            return false;
        }
        if (other.accessControlPolicy() == null ^ this.accessControlPolicy() == null) {
            return false;
        }
        if (other.accessControlPolicy() != null && !other.accessControlPolicy().equals(this.accessControlPolicy())) {
            return false;
        }
        if (other.bucket() == null ^ this.bucket() == null) {
            return false;
        }
        if (other.bucket() != null && !other.bucket().equals(this.bucket())) {
            return false;
        }
        if (other.contentMD5() == null ^ this.contentMD5() == null) {
            return false;
        }
        if (other.contentMD5() != null && !other.contentMD5().equals(this.contentMD5())) {
            return false;
        }
        if (other.grantFullControl() == null ^ this.grantFullControl() == null) {
            return false;
        }
        if (other.grantFullControl() != null && !other.grantFullControl().equals(this.grantFullControl())) {
            return false;
        }
        if (other.grantRead() == null ^ this.grantRead() == null) {
            return false;
        }
        if (other.grantRead() != null && !other.grantRead().equals(this.grantRead())) {
            return false;
        }
        if (other.grantReadACP() == null ^ this.grantReadACP() == null) {
            return false;
        }
        if (other.grantReadACP() != null && !other.grantReadACP().equals(this.grantReadACP())) {
            return false;
        }
        if (other.grantWrite() == null ^ this.grantWrite() == null) {
            return false;
        }
        if (other.grantWrite() != null && !other.grantWrite().equals(this.grantWrite())) {
            return false;
        }
        if (other.grantWriteACP() == null ^ this.grantWriteACP() == null) {
            return false;
        }
        if (other.grantWriteACP() != null && !other.grantWriteACP().equals(this.grantWriteACP())) {
            return false;
        }
        if (other.key() == null ^ this.key() == null) {
            return false;
        }
        if (other.key() != null && !other.key().equals(this.key())) {
            return false;
        }
        if (other.requestPayer() == null ^ this.requestPayer() == null) {
            return false;
        }
        if (other.requestPayer() != null && !other.requestPayer().equals(this.requestPayer())) {
            return false;
        }
        if (other.versionId() == null ^ this.versionId() == null) {
            return false;
        }
        return other.versionId() == null || other.versionId().equals(this.versionId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.acl() != null) {
            sb.append("ACL: ").append(this.acl()).append(",");
        }
        if (this.accessControlPolicy() != null) {
            sb.append("AccessControlPolicy: ").append(this.accessControlPolicy()).append(",");
        }
        if (this.bucket() != null) {
            sb.append("Bucket: ").append(this.bucket()).append(",");
        }
        if (this.contentMD5() != null) {
            sb.append("ContentMD5: ").append(this.contentMD5()).append(",");
        }
        if (this.grantFullControl() != null) {
            sb.append("GrantFullControl: ").append(this.grantFullControl()).append(",");
        }
        if (this.grantRead() != null) {
            sb.append("GrantRead: ").append(this.grantRead()).append(",");
        }
        if (this.grantReadACP() != null) {
            sb.append("GrantReadACP: ").append(this.grantReadACP()).append(",");
        }
        if (this.grantWrite() != null) {
            sb.append("GrantWrite: ").append(this.grantWrite()).append(",");
        }
        if (this.grantWriteACP() != null) {
            sb.append("GrantWriteACP: ").append(this.grantWriteACP()).append(",");
        }
        if (this.key() != null) {
            sb.append("Key: ").append(this.key()).append(",");
        }
        if (this.requestPayer() != null) {
            sb.append("RequestPayer: ").append(this.requestPayer()).append(",");
        }
        if (this.versionId() != null) {
            sb.append("VersionId: ").append(this.versionId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String acl;
        private AccessControlPolicy accessControlPolicy;
        private String bucket;
        private String contentMD5;
        private String grantFullControl;
        private String grantRead;
        private String grantReadACP;
        private String grantWrite;
        private String grantWriteACP;
        private String key;
        private String requestPayer;
        private String versionId;

        private BuilderImpl() {
        }

        private BuilderImpl(PutObjectAclRequest model) {
            this.setACL(model.acl);
            this.setAccessControlPolicy(model.accessControlPolicy);
            this.setBucket(model.bucket);
            this.setContentMD5(model.contentMD5);
            this.setGrantFullControl(model.grantFullControl);
            this.setGrantRead(model.grantRead);
            this.setGrantReadACP(model.grantReadACP);
            this.setGrantWrite(model.grantWrite);
            this.setGrantWriteACP(model.grantWriteACP);
            this.setKey(model.key);
            this.setRequestPayer(model.requestPayer);
            this.setVersionId(model.versionId);
        }

        public final String getACL() {
            return this.acl;
        }

        @Override
        public final Builder acl(String acl) {
            this.acl = acl;
            return this;
        }

        @Override
        public final Builder acl(ObjectCannedACL acl) {
            this.acl(acl.toString());
            return this;
        }

        public final void setACL(String acl) {
            this.acl = acl;
        }

        public final AccessControlPolicy getAccessControlPolicy() {
            return this.accessControlPolicy;
        }

        @Override
        public final Builder accessControlPolicy(AccessControlPolicy accessControlPolicy) {
            this.accessControlPolicy = accessControlPolicy;
            return this;
        }

        public final void setAccessControlPolicy(AccessControlPolicy accessControlPolicy) {
            this.accessControlPolicy = accessControlPolicy;
        }

        public final String getBucket() {
            return this.bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getContentMD5() {
            return this.contentMD5;
        }

        @Override
        public final Builder contentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
            return this;
        }

        public final void setContentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
        }

        public final String getGrantFullControl() {
            return this.grantFullControl;
        }

        @Override
        public final Builder grantFullControl(String grantFullControl) {
            this.grantFullControl = grantFullControl;
            return this;
        }

        public final void setGrantFullControl(String grantFullControl) {
            this.grantFullControl = grantFullControl;
        }

        public final String getGrantRead() {
            return this.grantRead;
        }

        @Override
        public final Builder grantRead(String grantRead) {
            this.grantRead = grantRead;
            return this;
        }

        public final void setGrantRead(String grantRead) {
            this.grantRead = grantRead;
        }

        public final String getGrantReadACP() {
            return this.grantReadACP;
        }

        @Override
        public final Builder grantReadACP(String grantReadACP) {
            this.grantReadACP = grantReadACP;
            return this;
        }

        public final void setGrantReadACP(String grantReadACP) {
            this.grantReadACP = grantReadACP;
        }

        public final String getGrantWrite() {
            return this.grantWrite;
        }

        @Override
        public final Builder grantWrite(String grantWrite) {
            this.grantWrite = grantWrite;
            return this;
        }

        public final void setGrantWrite(String grantWrite) {
            this.grantWrite = grantWrite;
        }

        public final String getGrantWriteACP() {
            return this.grantWriteACP;
        }

        @Override
        public final Builder grantWriteACP(String grantWriteACP) {
            this.grantWriteACP = grantWriteACP;
            return this;
        }

        public final void setGrantWriteACP(String grantWriteACP) {
            this.grantWriteACP = grantWriteACP;
        }

        public final String getKey() {
            return this.key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getRequestPayer() {
            return this.requestPayer;
        }

        @Override
        public final Builder requestPayer(String requestPayer) {
            this.requestPayer = requestPayer;
            return this;
        }

        @Override
        public final Builder requestPayer(RequestPayer requestPayer) {
            this.requestPayer(requestPayer.toString());
            return this;
        }

        public final void setRequestPayer(String requestPayer) {
            this.requestPayer = requestPayer;
        }

        public final String getVersionId() {
            return this.versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        public PutObjectAclRequest build() {
            return new PutObjectAclRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutObjectAclRequest> {
        public Builder acl(String var1);

        public Builder acl(ObjectCannedACL var1);

        public Builder accessControlPolicy(AccessControlPolicy var1);

        public Builder bucket(String var1);

        public Builder contentMD5(String var1);

        public Builder grantFullControl(String var1);

        public Builder grantRead(String var1);

        public Builder grantReadACP(String var1);

        public Builder grantWrite(String var1);

        public Builder grantWriteACP(String var1);

        public Builder key(String var1);

        public Builder requestPayer(String var1);

        public Builder requestPayer(RequestPayer var1);

        public Builder versionId(String var1);
    }
}

