/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.s3.model.RequestPayer;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListPartsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ListPartsRequest> {
    private final String bucket;
    private final String key;
    private final Integer maxParts;
    private final Integer partNumberMarker;
    private final String uploadId;
    private final String requestPayer;

    private ListPartsRequest(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.key = builder.key;
        this.maxParts = builder.maxParts;
        this.partNumberMarker = builder.partNumberMarker;
        this.uploadId = builder.uploadId;
        this.requestPayer = builder.requestPayer;
    }

    public String bucket() {
        return this.bucket;
    }

    public String key() {
        return this.key;
    }

    public Integer maxParts() {
        return this.maxParts;
    }

    public Integer partNumberMarker() {
        return this.partNumberMarker;
    }

    public String uploadId() {
        return this.uploadId;
    }

    public String requestPayer() {
        return this.requestPayer;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.bucket() == null ? 0 : this.bucket().hashCode());
        hashCode = 31 * hashCode + (this.key() == null ? 0 : this.key().hashCode());
        hashCode = 31 * hashCode + (this.maxParts() == null ? 0 : this.maxParts().hashCode());
        hashCode = 31 * hashCode + (this.partNumberMarker() == null ? 0 : this.partNumberMarker().hashCode());
        hashCode = 31 * hashCode + (this.uploadId() == null ? 0 : this.uploadId().hashCode());
        hashCode = 31 * hashCode + (this.requestPayer() == null ? 0 : this.requestPayer().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPartsRequest)) {
            return false;
        }
        ListPartsRequest other = (ListPartsRequest)((Object)obj);
        if (other.bucket() == null ^ this.bucket() == null) {
            return false;
        }
        if (other.bucket() != null && !other.bucket().equals(this.bucket())) {
            return false;
        }
        if (other.key() == null ^ this.key() == null) {
            return false;
        }
        if (other.key() != null && !other.key().equals(this.key())) {
            return false;
        }
        if (other.maxParts() == null ^ this.maxParts() == null) {
            return false;
        }
        if (other.maxParts() != null && !other.maxParts().equals(this.maxParts())) {
            return false;
        }
        if (other.partNumberMarker() == null ^ this.partNumberMarker() == null) {
            return false;
        }
        if (other.partNumberMarker() != null && !other.partNumberMarker().equals(this.partNumberMarker())) {
            return false;
        }
        if (other.uploadId() == null ^ this.uploadId() == null) {
            return false;
        }
        if (other.uploadId() != null && !other.uploadId().equals(this.uploadId())) {
            return false;
        }
        if (other.requestPayer() == null ^ this.requestPayer() == null) {
            return false;
        }
        return other.requestPayer() == null || other.requestPayer().equals(this.requestPayer());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.bucket() != null) {
            sb.append("Bucket: ").append(this.bucket()).append(",");
        }
        if (this.key() != null) {
            sb.append("Key: ").append(this.key()).append(",");
        }
        if (this.maxParts() != null) {
            sb.append("MaxParts: ").append(this.maxParts()).append(",");
        }
        if (this.partNumberMarker() != null) {
            sb.append("PartNumberMarker: ").append(this.partNumberMarker()).append(",");
        }
        if (this.uploadId() != null) {
            sb.append("UploadId: ").append(this.uploadId()).append(",");
        }
        if (this.requestPayer() != null) {
            sb.append("RequestPayer: ").append(this.requestPayer()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String bucket;
        private String key;
        private Integer maxParts;
        private Integer partNumberMarker;
        private String uploadId;
        private String requestPayer;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPartsRequest model) {
            this.setBucket(model.bucket);
            this.setKey(model.key);
            this.setMaxParts(model.maxParts);
            this.setPartNumberMarker(model.partNumberMarker);
            this.setUploadId(model.uploadId);
            this.setRequestPayer(model.requestPayer);
        }

        public final String getBucket() {
            return this.bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getKey() {
            return this.key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final Integer getMaxParts() {
            return this.maxParts;
        }

        @Override
        public final Builder maxParts(Integer maxParts) {
            this.maxParts = maxParts;
            return this;
        }

        public final void setMaxParts(Integer maxParts) {
            this.maxParts = maxParts;
        }

        public final Integer getPartNumberMarker() {
            return this.partNumberMarker;
        }

        @Override
        public final Builder partNumberMarker(Integer partNumberMarker) {
            this.partNumberMarker = partNumberMarker;
            return this;
        }

        public final void setPartNumberMarker(Integer partNumberMarker) {
            this.partNumberMarker = partNumberMarker;
        }

        public final String getUploadId() {
            return this.uploadId;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public final void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        public final String getRequestPayer() {
            return this.requestPayer;
        }

        @Override
        public final Builder requestPayer(String requestPayer) {
            this.requestPayer = requestPayer;
            return this;
        }

        @Override
        public final Builder requestPayer(RequestPayer requestPayer) {
            this.requestPayer(requestPayer.toString());
            return this;
        }

        public final void setRequestPayer(String requestPayer) {
            this.requestPayer = requestPayer;
        }

        public ListPartsRequest build() {
            return new ListPartsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListPartsRequest> {
        public Builder bucket(String var1);

        public Builder key(String var1);

        public Builder maxParts(Integer var1);

        public Builder partNumberMarker(Integer var1);

        public Builder uploadId(String var1);

        public Builder requestPayer(String var1);

        public Builder requestPayer(RequestPayer var1);
    }
}

