/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.s3.model.CommonPrefix;
import software.amazon.awssdk.services.s3.model.CommonPrefixListCopier;
import software.amazon.awssdk.services.s3.model.DeleteMarkerEntry;
import software.amazon.awssdk.services.s3.model.DeleteMarkersCopier;
import software.amazon.awssdk.services.s3.model.EncodingType;
import software.amazon.awssdk.services.s3.model.ObjectVersion;
import software.amazon.awssdk.services.s3.model.ObjectVersionListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListObjectVersionsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListObjectVersionsResponse> {
    private final Boolean isTruncated;
    private final String keyMarker;
    private final String versionIdMarker;
    private final String nextKeyMarker;
    private final String nextVersionIdMarker;
    private final List<ObjectVersion> versions;
    private final List<DeleteMarkerEntry> deleteMarkers;
    private final String name;
    private final String prefix;
    private final String delimiter;
    private final Integer maxKeys;
    private final List<CommonPrefix> commonPrefixes;
    private final String encodingType;

    private ListObjectVersionsResponse(BuilderImpl builder) {
        this.isTruncated = builder.isTruncated;
        this.keyMarker = builder.keyMarker;
        this.versionIdMarker = builder.versionIdMarker;
        this.nextKeyMarker = builder.nextKeyMarker;
        this.nextVersionIdMarker = builder.nextVersionIdMarker;
        this.versions = builder.versions;
        this.deleteMarkers = builder.deleteMarkers;
        this.name = builder.name;
        this.prefix = builder.prefix;
        this.delimiter = builder.delimiter;
        this.maxKeys = builder.maxKeys;
        this.commonPrefixes = builder.commonPrefixes;
        this.encodingType = builder.encodingType;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public String keyMarker() {
        return this.keyMarker;
    }

    public String versionIdMarker() {
        return this.versionIdMarker;
    }

    public String nextKeyMarker() {
        return this.nextKeyMarker;
    }

    public String nextVersionIdMarker() {
        return this.nextVersionIdMarker;
    }

    public List<ObjectVersion> versions() {
        return this.versions;
    }

    public List<DeleteMarkerEntry> deleteMarkers() {
        return this.deleteMarkers;
    }

    public String name() {
        return this.name;
    }

    public String prefix() {
        return this.prefix;
    }

    public String delimiter() {
        return this.delimiter;
    }

    public Integer maxKeys() {
        return this.maxKeys;
    }

    public List<CommonPrefix> commonPrefixes() {
        return this.commonPrefixes;
    }

    public String encodingType() {
        return this.encodingType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.isTruncated() == null ? 0 : this.isTruncated().hashCode());
        hashCode = 31 * hashCode + (this.keyMarker() == null ? 0 : this.keyMarker().hashCode());
        hashCode = 31 * hashCode + (this.versionIdMarker() == null ? 0 : this.versionIdMarker().hashCode());
        hashCode = 31 * hashCode + (this.nextKeyMarker() == null ? 0 : this.nextKeyMarker().hashCode());
        hashCode = 31 * hashCode + (this.nextVersionIdMarker() == null ? 0 : this.nextVersionIdMarker().hashCode());
        hashCode = 31 * hashCode + (this.versions() == null ? 0 : this.versions().hashCode());
        hashCode = 31 * hashCode + (this.deleteMarkers() == null ? 0 : this.deleteMarkers().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.prefix() == null ? 0 : this.prefix().hashCode());
        hashCode = 31 * hashCode + (this.delimiter() == null ? 0 : this.delimiter().hashCode());
        hashCode = 31 * hashCode + (this.maxKeys() == null ? 0 : this.maxKeys().hashCode());
        hashCode = 31 * hashCode + (this.commonPrefixes() == null ? 0 : this.commonPrefixes().hashCode());
        hashCode = 31 * hashCode + (this.encodingType() == null ? 0 : this.encodingType().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListObjectVersionsResponse)) {
            return false;
        }
        ListObjectVersionsResponse other = (ListObjectVersionsResponse)((Object)obj);
        if (other.isTruncated() == null ^ this.isTruncated() == null) {
            return false;
        }
        if (other.isTruncated() != null && !other.isTruncated().equals(this.isTruncated())) {
            return false;
        }
        if (other.keyMarker() == null ^ this.keyMarker() == null) {
            return false;
        }
        if (other.keyMarker() != null && !other.keyMarker().equals(this.keyMarker())) {
            return false;
        }
        if (other.versionIdMarker() == null ^ this.versionIdMarker() == null) {
            return false;
        }
        if (other.versionIdMarker() != null && !other.versionIdMarker().equals(this.versionIdMarker())) {
            return false;
        }
        if (other.nextKeyMarker() == null ^ this.nextKeyMarker() == null) {
            return false;
        }
        if (other.nextKeyMarker() != null && !other.nextKeyMarker().equals(this.nextKeyMarker())) {
            return false;
        }
        if (other.nextVersionIdMarker() == null ^ this.nextVersionIdMarker() == null) {
            return false;
        }
        if (other.nextVersionIdMarker() != null && !other.nextVersionIdMarker().equals(this.nextVersionIdMarker())) {
            return false;
        }
        if (other.versions() == null ^ this.versions() == null) {
            return false;
        }
        if (other.versions() != null && !other.versions().equals(this.versions())) {
            return false;
        }
        if (other.deleteMarkers() == null ^ this.deleteMarkers() == null) {
            return false;
        }
        if (other.deleteMarkers() != null && !other.deleteMarkers().equals(this.deleteMarkers())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.prefix() == null ^ this.prefix() == null) {
            return false;
        }
        if (other.prefix() != null && !other.prefix().equals(this.prefix())) {
            return false;
        }
        if (other.delimiter() == null ^ this.delimiter() == null) {
            return false;
        }
        if (other.delimiter() != null && !other.delimiter().equals(this.delimiter())) {
            return false;
        }
        if (other.maxKeys() == null ^ this.maxKeys() == null) {
            return false;
        }
        if (other.maxKeys() != null && !other.maxKeys().equals(this.maxKeys())) {
            return false;
        }
        if (other.commonPrefixes() == null ^ this.commonPrefixes() == null) {
            return false;
        }
        if (other.commonPrefixes() != null && !other.commonPrefixes().equals(this.commonPrefixes())) {
            return false;
        }
        if (other.encodingType() == null ^ this.encodingType() == null) {
            return false;
        }
        return other.encodingType() == null || other.encodingType().equals(this.encodingType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.isTruncated() != null) {
            sb.append("IsTruncated: ").append(this.isTruncated()).append(",");
        }
        if (this.keyMarker() != null) {
            sb.append("KeyMarker: ").append(this.keyMarker()).append(",");
        }
        if (this.versionIdMarker() != null) {
            sb.append("VersionIdMarker: ").append(this.versionIdMarker()).append(",");
        }
        if (this.nextKeyMarker() != null) {
            sb.append("NextKeyMarker: ").append(this.nextKeyMarker()).append(",");
        }
        if (this.nextVersionIdMarker() != null) {
            sb.append("NextVersionIdMarker: ").append(this.nextVersionIdMarker()).append(",");
        }
        if (this.versions() != null) {
            sb.append("Versions: ").append(this.versions()).append(",");
        }
        if (this.deleteMarkers() != null) {
            sb.append("DeleteMarkers: ").append(this.deleteMarkers()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.prefix() != null) {
            sb.append("Prefix: ").append(this.prefix()).append(",");
        }
        if (this.delimiter() != null) {
            sb.append("Delimiter: ").append(this.delimiter()).append(",");
        }
        if (this.maxKeys() != null) {
            sb.append("MaxKeys: ").append(this.maxKeys()).append(",");
        }
        if (this.commonPrefixes() != null) {
            sb.append("CommonPrefixes: ").append(this.commonPrefixes()).append(",");
        }
        if (this.encodingType() != null) {
            sb.append("EncodingType: ").append(this.encodingType()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Boolean isTruncated;
        private String keyMarker;
        private String versionIdMarker;
        private String nextKeyMarker;
        private String nextVersionIdMarker;
        private List<ObjectVersion> versions;
        private List<DeleteMarkerEntry> deleteMarkers;
        private String name;
        private String prefix;
        private String delimiter;
        private Integer maxKeys;
        private List<CommonPrefix> commonPrefixes;
        private String encodingType;

        private BuilderImpl() {
        }

        private BuilderImpl(ListObjectVersionsResponse model) {
            this.setIsTruncated(model.isTruncated);
            this.setKeyMarker(model.keyMarker);
            this.setVersionIdMarker(model.versionIdMarker);
            this.setNextKeyMarker(model.nextKeyMarker);
            this.setNextVersionIdMarker(model.nextVersionIdMarker);
            this.setVersions(model.versions);
            this.setDeleteMarkers(model.deleteMarkers);
            this.setName(model.name);
            this.setPrefix(model.prefix);
            this.setDelimiter(model.delimiter);
            this.setMaxKeys(model.maxKeys);
            this.setCommonPrefixes(model.commonPrefixes);
            this.setEncodingType(model.encodingType);
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getKeyMarker() {
            return this.keyMarker;
        }

        @Override
        public final Builder keyMarker(String keyMarker) {
            this.keyMarker = keyMarker;
            return this;
        }

        public final void setKeyMarker(String keyMarker) {
            this.keyMarker = keyMarker;
        }

        public final String getVersionIdMarker() {
            return this.versionIdMarker;
        }

        @Override
        public final Builder versionIdMarker(String versionIdMarker) {
            this.versionIdMarker = versionIdMarker;
            return this;
        }

        public final void setVersionIdMarker(String versionIdMarker) {
            this.versionIdMarker = versionIdMarker;
        }

        public final String getNextKeyMarker() {
            return this.nextKeyMarker;
        }

        @Override
        public final Builder nextKeyMarker(String nextKeyMarker) {
            this.nextKeyMarker = nextKeyMarker;
            return this;
        }

        public final void setNextKeyMarker(String nextKeyMarker) {
            this.nextKeyMarker = nextKeyMarker;
        }

        public final String getNextVersionIdMarker() {
            return this.nextVersionIdMarker;
        }

        @Override
        public final Builder nextVersionIdMarker(String nextVersionIdMarker) {
            this.nextVersionIdMarker = nextVersionIdMarker;
            return this;
        }

        public final void setNextVersionIdMarker(String nextVersionIdMarker) {
            this.nextVersionIdMarker = nextVersionIdMarker;
        }

        public final Collection<ObjectVersion> getVersions() {
            return this.versions;
        }

        @Override
        public final Builder versions(Collection<ObjectVersion> versions) {
            this.versions = ObjectVersionListCopier.copy(versions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder versions(ObjectVersion ... versions) {
            this.versions(Arrays.asList(versions));
            return this;
        }

        public final void setVersions(Collection<ObjectVersion> versions) {
            this.versions = ObjectVersionListCopier.copy(versions);
        }

        public final Collection<DeleteMarkerEntry> getDeleteMarkers() {
            return this.deleteMarkers;
        }

        @Override
        public final Builder deleteMarkers(Collection<DeleteMarkerEntry> deleteMarkers) {
            this.deleteMarkers = DeleteMarkersCopier.copy(deleteMarkers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deleteMarkers(DeleteMarkerEntry ... deleteMarkers) {
            this.deleteMarkers(Arrays.asList(deleteMarkers));
            return this;
        }

        public final void setDeleteMarkers(Collection<DeleteMarkerEntry> deleteMarkers) {
            this.deleteMarkers = DeleteMarkersCopier.copy(deleteMarkers);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getPrefix() {
            return this.prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final String getDelimiter() {
            return this.delimiter;
        }

        @Override
        public final Builder delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public final void setDelimiter(String delimiter) {
            this.delimiter = delimiter;
        }

        public final Integer getMaxKeys() {
            return this.maxKeys;
        }

        @Override
        public final Builder maxKeys(Integer maxKeys) {
            this.maxKeys = maxKeys;
            return this;
        }

        public final void setMaxKeys(Integer maxKeys) {
            this.maxKeys = maxKeys;
        }

        public final Collection<CommonPrefix> getCommonPrefixes() {
            return this.commonPrefixes;
        }

        @Override
        public final Builder commonPrefixes(Collection<CommonPrefix> commonPrefixes) {
            this.commonPrefixes = CommonPrefixListCopier.copy(commonPrefixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commonPrefixes(CommonPrefix ... commonPrefixes) {
            this.commonPrefixes(Arrays.asList(commonPrefixes));
            return this;
        }

        public final void setCommonPrefixes(Collection<CommonPrefix> commonPrefixes) {
            this.commonPrefixes = CommonPrefixListCopier.copy(commonPrefixes);
        }

        public final String getEncodingType() {
            return this.encodingType;
        }

        @Override
        public final Builder encodingType(String encodingType) {
            this.encodingType = encodingType;
            return this;
        }

        @Override
        public final Builder encodingType(EncodingType encodingType) {
            this.encodingType(encodingType.toString());
            return this;
        }

        public final void setEncodingType(String encodingType) {
            this.encodingType = encodingType;
        }

        public ListObjectVersionsResponse build() {
            return new ListObjectVersionsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListObjectVersionsResponse> {
        public Builder isTruncated(Boolean var1);

        public Builder keyMarker(String var1);

        public Builder versionIdMarker(String var1);

        public Builder nextKeyMarker(String var1);

        public Builder nextVersionIdMarker(String var1);

        public Builder versions(Collection<ObjectVersion> var1);

        public Builder versions(ObjectVersion ... var1);

        public Builder deleteMarkers(Collection<DeleteMarkerEntry> var1);

        public Builder deleteMarkers(DeleteMarkerEntry ... var1);

        public Builder name(String var1);

        public Builder prefix(String var1);

        public Builder delimiter(String var1);

        public Builder maxKeys(Integer var1);

        public Builder commonPrefixes(Collection<CommonPrefix> var1);

        public Builder commonPrefixes(CommonPrefix ... var1);

        public Builder encodingType(String var1);

        public Builder encodingType(EncodingType var1);
    }
}

