/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.s3.model.ErrorDocument;
import software.amazon.awssdk.services.s3.model.IndexDocument;
import software.amazon.awssdk.services.s3.model.RedirectAllRequestsTo;
import software.amazon.awssdk.services.s3.model.RoutingRule;
import software.amazon.awssdk.services.s3.model.RoutingRulesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetBucketWebsiteResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetBucketWebsiteResponse> {
    private final RedirectAllRequestsTo redirectAllRequestsTo;
    private final IndexDocument indexDocument;
    private final ErrorDocument errorDocument;
    private final List<RoutingRule> routingRules;

    private GetBucketWebsiteResponse(BuilderImpl builder) {
        this.redirectAllRequestsTo = builder.redirectAllRequestsTo;
        this.indexDocument = builder.indexDocument;
        this.errorDocument = builder.errorDocument;
        this.routingRules = builder.routingRules;
    }

    public RedirectAllRequestsTo redirectAllRequestsTo() {
        return this.redirectAllRequestsTo;
    }

    public IndexDocument indexDocument() {
        return this.indexDocument;
    }

    public ErrorDocument errorDocument() {
        return this.errorDocument;
    }

    public List<RoutingRule> routingRules() {
        return this.routingRules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.redirectAllRequestsTo() == null ? 0 : this.redirectAllRequestsTo().hashCode());
        hashCode = 31 * hashCode + (this.indexDocument() == null ? 0 : this.indexDocument().hashCode());
        hashCode = 31 * hashCode + (this.errorDocument() == null ? 0 : this.errorDocument().hashCode());
        hashCode = 31 * hashCode + (this.routingRules() == null ? 0 : this.routingRules().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBucketWebsiteResponse)) {
            return false;
        }
        GetBucketWebsiteResponse other = (GetBucketWebsiteResponse)((Object)obj);
        if (other.redirectAllRequestsTo() == null ^ this.redirectAllRequestsTo() == null) {
            return false;
        }
        if (other.redirectAllRequestsTo() != null && !other.redirectAllRequestsTo().equals(this.redirectAllRequestsTo())) {
            return false;
        }
        if (other.indexDocument() == null ^ this.indexDocument() == null) {
            return false;
        }
        if (other.indexDocument() != null && !other.indexDocument().equals(this.indexDocument())) {
            return false;
        }
        if (other.errorDocument() == null ^ this.errorDocument() == null) {
            return false;
        }
        if (other.errorDocument() != null && !other.errorDocument().equals(this.errorDocument())) {
            return false;
        }
        if (other.routingRules() == null ^ this.routingRules() == null) {
            return false;
        }
        return other.routingRules() == null || other.routingRules().equals(this.routingRules());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.redirectAllRequestsTo() != null) {
            sb.append("RedirectAllRequestsTo: ").append(this.redirectAllRequestsTo()).append(",");
        }
        if (this.indexDocument() != null) {
            sb.append("IndexDocument: ").append(this.indexDocument()).append(",");
        }
        if (this.errorDocument() != null) {
            sb.append("ErrorDocument: ").append(this.errorDocument()).append(",");
        }
        if (this.routingRules() != null) {
            sb.append("RoutingRules: ").append(this.routingRules()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private RedirectAllRequestsTo redirectAllRequestsTo;
        private IndexDocument indexDocument;
        private ErrorDocument errorDocument;
        private List<RoutingRule> routingRules;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBucketWebsiteResponse model) {
            this.setRedirectAllRequestsTo(model.redirectAllRequestsTo);
            this.setIndexDocument(model.indexDocument);
            this.setErrorDocument(model.errorDocument);
            this.setRoutingRules(model.routingRules);
        }

        public final RedirectAllRequestsTo getRedirectAllRequestsTo() {
            return this.redirectAllRequestsTo;
        }

        @Override
        public final Builder redirectAllRequestsTo(RedirectAllRequestsTo redirectAllRequestsTo) {
            this.redirectAllRequestsTo = redirectAllRequestsTo;
            return this;
        }

        public final void setRedirectAllRequestsTo(RedirectAllRequestsTo redirectAllRequestsTo) {
            this.redirectAllRequestsTo = redirectAllRequestsTo;
        }

        public final IndexDocument getIndexDocument() {
            return this.indexDocument;
        }

        @Override
        public final Builder indexDocument(IndexDocument indexDocument) {
            this.indexDocument = indexDocument;
            return this;
        }

        public final void setIndexDocument(IndexDocument indexDocument) {
            this.indexDocument = indexDocument;
        }

        public final ErrorDocument getErrorDocument() {
            return this.errorDocument;
        }

        @Override
        public final Builder errorDocument(ErrorDocument errorDocument) {
            this.errorDocument = errorDocument;
            return this;
        }

        public final void setErrorDocument(ErrorDocument errorDocument) {
            this.errorDocument = errorDocument;
        }

        public final Collection<RoutingRule> getRoutingRules() {
            return this.routingRules;
        }

        @Override
        public final Builder routingRules(Collection<RoutingRule> routingRules) {
            this.routingRules = RoutingRulesCopier.copy(routingRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingRules(RoutingRule ... routingRules) {
            this.routingRules(Arrays.asList(routingRules));
            return this;
        }

        public final void setRoutingRules(Collection<RoutingRule> routingRules) {
            this.routingRules = RoutingRulesCopier.copy(routingRules);
        }

        public GetBucketWebsiteResponse build() {
            return new GetBucketWebsiteResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetBucketWebsiteResponse> {
        public Builder redirectAllRequestsTo(RedirectAllRequestsTo var1);

        public Builder indexDocument(IndexDocument var1);

        public Builder errorDocument(ErrorDocument var1);

        public Builder routingRules(Collection<RoutingRule> var1);

        public Builder routingRules(RoutingRule ... var1);
    }
}

