/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3;

import software.amazon.awssdk.ServiceAdvancedConfiguration;
import software.amazon.awssdk.annotation.Immutable;
import software.amazon.awssdk.annotation.NotThreadSafe;
import software.amazon.awssdk.annotation.ThreadSafe;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@Immutable
@ThreadSafe
public final class S3AdvancedConfiguration
implements ServiceAdvancedConfiguration,
ToCopyableBuilder<Builder, S3AdvancedConfiguration> {
    private static final boolean DEFAULT_PATH_STYLE_ACCESS_ENABLED = false;
    private static final boolean DEFAULT_ACCELERATE_MODE_ENABLED = false;
    private static final boolean DEFAULT_DUALSTACK_ENABLED = false;
    private final Boolean pathStyleAccessEnabled;
    private final Boolean accelerateModeEnabled;
    private final Boolean dualstackEnabled;

    private S3AdvancedConfiguration(DefaultS3AdvancedConfigurationBuilder builder) {
        this.dualstackEnabled = this.resolveBoolean(builder.dualstackEnabled, false);
        this.accelerateModeEnabled = this.resolveBoolean(builder.accelerateModeEnabled, false);
        this.pathStyleAccessEnabled = this.resolveBoolean(builder.pathStyleAccessEnabled, false);
        if (this.accelerateModeEnabled.booleanValue() && this.pathStyleAccessEnabled.booleanValue()) {
            throw new IllegalArgumentException("Accelerate mode cannot be used with path style addressing");
        }
    }

    public static Builder builder() {
        return new DefaultS3AdvancedConfigurationBuilder();
    }

    public boolean pathStyleAccessEnabled() {
        return this.pathStyleAccessEnabled;
    }

    public boolean accelerateModeEnabled() {
        return this.accelerateModeEnabled;
    }

    public boolean dualstackEnabled() {
        return this.dualstackEnabled;
    }

    private boolean resolveBoolean(Boolean customerSuppliedValue, boolean defaultValue) {
        return customerSuppliedValue == null ? defaultValue : customerSuppliedValue;
    }

    public Builder toBuilder() {
        return S3AdvancedConfiguration.builder().dualstackEnabled(this.dualstackEnabled).accelerateModeEnabled(this.accelerateModeEnabled).pathStyleAccessEnabled(this.pathStyleAccessEnabled);
    }

    private static final class DefaultS3AdvancedConfigurationBuilder
    implements Builder {
        private Boolean dualstackEnabled;
        private Boolean accelerateModeEnabled;
        private Boolean pathStyleAccessEnabled;

        private DefaultS3AdvancedConfigurationBuilder() {
        }

        @Override
        public Builder dualstackEnabled(Boolean dualstackEnabled) {
            this.dualstackEnabled = dualstackEnabled;
            return this;
        }

        public void setDualstackEnabled(Boolean dualstackEnabled) {
            this.dualstackEnabled(dualstackEnabled);
        }

        @Override
        public Builder accelerateModeEnabled(Boolean accelerateModeEnabled) {
            this.accelerateModeEnabled = accelerateModeEnabled;
            return this;
        }

        public void setAccelerateModeEnabled(Boolean accelerateModeEnabled) {
            this.accelerateModeEnabled(accelerateModeEnabled);
        }

        @Override
        public Builder pathStyleAccessEnabled(Boolean pathStyleAccessEnabled) {
            this.pathStyleAccessEnabled = pathStyleAccessEnabled;
            return this;
        }

        public void setPathStyleAccessEnabled(Boolean pathStyleAccessEnabled) {
            this.pathStyleAccessEnabled(pathStyleAccessEnabled);
        }

        public S3AdvancedConfiguration build() {
            return new S3AdvancedConfiguration(this);
        }
    }

    @NotThreadSafe
    public static interface Builder
    extends CopyableBuilder<Builder, S3AdvancedConfiguration> {
        public Builder dualstackEnabled(Boolean var1);

        public Builder accelerateModeEnabled(Boolean var1);

        public Builder pathStyleAccessEnabled(Boolean var1);
    }
}

