/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.RoutingRule;
import software.amazon.awssdk.services.s3.model.WebsiteConfiguration;
import software.amazon.awssdk.services.s3.transform.ErrorDocumentUnmarshaller;
import software.amazon.awssdk.services.s3.transform.IndexDocumentUnmarshaller;
import software.amazon.awssdk.services.s3.transform.RedirectAllRequestsToUnmarshaller;
import software.amazon.awssdk.services.s3.transform.RoutingRuleUnmarshaller;

public class WebsiteConfigurationUnmarshaller
implements Unmarshaller<WebsiteConfiguration, StaxUnmarshallerContext> {
    private static final WebsiteConfigurationUnmarshaller INSTANCE = new WebsiteConfigurationUnmarshaller();

    public WebsiteConfiguration unmarshall(StaxUnmarshallerContext context) throws Exception {
        WebsiteConfiguration.Builder websiteConfiguration;
        block8: {
            websiteConfiguration = WebsiteConfiguration.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<RoutingRule> routingRules = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    websiteConfiguration.routingRules(routingRules);
                    break block8;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("ErrorDocument", targetDepth)) {
                        websiteConfiguration.errorDocument(ErrorDocumentUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("IndexDocument", targetDepth)) {
                        websiteConfiguration.indexDocument(IndexDocumentUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("RedirectAllRequestsTo", targetDepth)) {
                        websiteConfiguration.redirectAllRequestsTo(RedirectAllRequestsToUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("RoutingRules", targetDepth)) {
                        routingRules = new ArrayList<RoutingRule>();
                        continue;
                    }
                    if (!context.testExpression("RoutingRules/RoutingRule", targetDepth)) continue;
                    routingRules.add(RoutingRuleUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            websiteConfiguration.routingRules(routingRules);
        }
        return (WebsiteConfiguration)websiteConfiguration.build();
    }

    public static WebsiteConfigurationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

