/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.core.util.UriResourcePathUtils;
import software.amazon.awssdk.core.util.xml.XmlWriter;
import software.amazon.awssdk.services.s3.model.CORSConfiguration;
import software.amazon.awssdk.services.s3.model.CORSRule;
import software.amazon.awssdk.services.s3.model.PutBucketCorsRequest;
import software.amazon.awssdk.utils.Md5Utils;
import software.amazon.awssdk.utils.StringInputStream;

public class PutBucketCorsRequestMarshaller
implements Marshaller<Request<PutBucketCorsRequest>, PutBucketCorsRequest> {
    public Request<PutBucketCorsRequest> marshall(PutBucketCorsRequest putBucketCorsRequest) {
        if (putBucketCorsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)putBucketCorsRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.PUT);
        if (putBucketCorsRequest.contentMD5() != null) {
            request.addHeader("Content-MD5", StringConversion.fromString((String)putBucketCorsRequest.contentMD5()));
        }
        String uriResourcePath = "/{Bucket}?cors";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParametersToRequest((Request)request, (String)uriResourcePath);
        uriResourcePath = PathMarshaller.NON_GREEDY.marshall(uriResourcePath, "Bucket", putBucketCorsRequest.bucket());
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = null;
            CORSConfiguration corsConfiguration = putBucketCorsRequest.corsConfiguration();
            if (corsConfiguration != null) {
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter((Writer)stringWriter, "http://s3.amazonaws.com/doc/2006-03-01/");
                xmlWriter.startElement("CORSConfiguration");
                List<CORSRule> cORSConfigurationCORSRulesList = corsConfiguration.corsRules();
                if (!cORSConfigurationCORSRulesList.isEmpty() || !(cORSConfigurationCORSRulesList instanceof SdkAutoConstructList)) {
                    for (CORSRule cORSConfigurationCORSRulesListValue : cORSConfigurationCORSRulesList) {
                        List<String> cORSRuleExposeHeadersList;
                        List<String> list;
                        List<String> cORSRuleAllowedMethodsList;
                        xmlWriter.startElement("CORSRule");
                        List<String> cORSRuleAllowedHeadersList = cORSConfigurationCORSRulesListValue.allowedHeaders();
                        if (!cORSRuleAllowedHeadersList.isEmpty() || !(cORSRuleAllowedHeadersList instanceof SdkAutoConstructList)) {
                            for (String string : cORSRuleAllowedHeadersList) {
                                xmlWriter.startElement("AllowedHeader");
                                xmlWriter.value(string);
                                xmlWriter.endElement();
                            }
                        }
                        if (!(cORSRuleAllowedMethodsList = cORSConfigurationCORSRulesListValue.allowedMethods()).isEmpty() || !(cORSRuleAllowedMethodsList instanceof SdkAutoConstructList)) {
                            for (Object cORSRuleAllowedMethodsListValue : cORSRuleAllowedMethodsList) {
                                xmlWriter.startElement("AllowedMethod");
                                xmlWriter.value((String)cORSRuleAllowedMethodsListValue);
                                xmlWriter.endElement();
                            }
                        }
                        if (!(list = cORSConfigurationCORSRulesListValue.allowedOrigins()).isEmpty() || !(list instanceof SdkAutoConstructList)) {
                            Object cORSRuleAllowedMethodsListValue;
                            cORSRuleAllowedMethodsListValue = list.iterator();
                            while (cORSRuleAllowedMethodsListValue.hasNext()) {
                                String cORSRuleAllowedOriginsListValue = (String)cORSRuleAllowedMethodsListValue.next();
                                xmlWriter.startElement("AllowedOrigin");
                                xmlWriter.value(cORSRuleAllowedOriginsListValue);
                                xmlWriter.endElement();
                            }
                        }
                        if (!(cORSRuleExposeHeadersList = cORSConfigurationCORSRulesListValue.exposeHeaders()).isEmpty() || !(cORSRuleExposeHeadersList instanceof SdkAutoConstructList)) {
                            for (String cORSRuleExposeHeadersListValue : cORSRuleExposeHeadersList) {
                                xmlWriter.startElement("ExposeHeader");
                                xmlWriter.value(cORSRuleExposeHeadersListValue);
                                xmlWriter.endElement();
                            }
                        }
                        if (cORSConfigurationCORSRulesListValue.maxAgeSeconds() != null) {
                            xmlWriter.startElement("MaxAgeSeconds").value((Object)cORSConfigurationCORSRulesListValue.maxAgeSeconds()).endElement();
                        }
                        xmlWriter.endElement();
                    }
                }
                xmlWriter.endElement();
            }
            if (stringWriter != null) {
                if (!request.getHeaders().containsKey("Content-MD5")) {
                    request.addHeader("Content-MD5", Md5Utils.md5AsBase64((byte[])stringWriter.getBuffer().toString().getBytes(StandardCharsets.UTF_8)));
                }
                request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StandardCharsets.UTF_8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw SdkClientException.builder().message("Unable to marshall request to XML: " + t.getMessage()).cause(t).build();
        }
        return request;
    }
}

