/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.core.util.UriResourcePathUtils;
import software.amazon.awssdk.services.s3.model.ListObjectVersionsRequest;

public class ListObjectVersionsRequestMarshaller
implements Marshaller<Request<ListObjectVersionsRequest>, ListObjectVersionsRequest> {
    public Request<ListObjectVersionsRequest> marshall(ListObjectVersionsRequest listObjectVersionsRequest) {
        if (listObjectVersionsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)listObjectVersionsRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/{Bucket}?versions";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParametersToRequest((Request)request, (String)uriResourcePath);
        uriResourcePath = PathMarshaller.NON_GREEDY.marshall(uriResourcePath, "Bucket", listObjectVersionsRequest.bucket());
        request.setResourcePath(uriResourcePath);
        if (listObjectVersionsRequest.delimiter() != null) {
            request.addParameter("delimiter", StringConversion.fromString((String)listObjectVersionsRequest.delimiter()));
        }
        if (listObjectVersionsRequest.encodingTypeAsString() != null) {
            request.addParameter("encoding-type", StringConversion.fromString((String)listObjectVersionsRequest.encodingTypeAsString()));
        }
        if (listObjectVersionsRequest.keyMarker() != null) {
            request.addParameter("key-marker", StringConversion.fromString((String)listObjectVersionsRequest.keyMarker()));
        }
        if (listObjectVersionsRequest.maxKeys() != null) {
            request.addParameter("max-keys", StringConversion.fromInteger((Integer)listObjectVersionsRequest.maxKeys()));
        }
        if (listObjectVersionsRequest.prefix() != null) {
            request.addParameter("prefix", StringConversion.fromString((String)listObjectVersionsRequest.prefix()));
        }
        if (listObjectVersionsRequest.versionIdMarker() != null) {
            request.addParameter("version-id-marker", StringConversion.fromString((String)listObjectVersionsRequest.versionIdMarker()));
        }
        return request;
    }
}

