/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.time.Instant;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;

public class GetObjectRequestMarshaller
implements Marshaller<Request<GetObjectRequest>, GetObjectRequest> {
    public Request<GetObjectRequest> marshall(GetObjectRequest getObjectRequest) {
        if (getObjectRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)getObjectRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.GET);
        if (getObjectRequest.ifMatch() != null) {
            request.addHeader("If-Match", StringConversion.fromString((String)getObjectRequest.ifMatch()));
        }
        if (getObjectRequest.ifModifiedSince() != null) {
            request.addHeader("If-Modified-Since", StringConversion.fromInstant((Instant)getObjectRequest.ifModifiedSince()));
        }
        if (getObjectRequest.ifNoneMatch() != null) {
            request.addHeader("If-None-Match", StringConversion.fromString((String)getObjectRequest.ifNoneMatch()));
        }
        if (getObjectRequest.ifUnmodifiedSince() != null) {
            request.addHeader("If-Unmodified-Since", StringConversion.fromInstant((Instant)getObjectRequest.ifUnmodifiedSince()));
        }
        if (getObjectRequest.range() != null) {
            request.addHeader("Range", StringConversion.fromString((String)getObjectRequest.range()));
        }
        if (getObjectRequest.sseCustomerAlgorithm() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-algorithm", StringConversion.fromString((String)getObjectRequest.sseCustomerAlgorithm()));
        }
        if (getObjectRequest.sseCustomerKey() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-key", StringConversion.fromString((String)getObjectRequest.sseCustomerKey()));
        }
        if (getObjectRequest.sseCustomerKeyMD5() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-key-MD5", StringConversion.fromString((String)getObjectRequest.sseCustomerKeyMD5()));
        }
        if (getObjectRequest.requestPayerAsString() != null) {
            request.addHeader("x-amz-request-payer", StringConversion.fromString((String)getObjectRequest.requestPayerAsString()));
        }
        String uriResourcePath = "/{Bucket}/{Key+}";
        uriResourcePath = PathMarshaller.NON_GREEDY.marshall(uriResourcePath, "Bucket", getObjectRequest.bucket());
        uriResourcePath = PathMarshaller.GREEDY.marshall(uriResourcePath, "Key", getObjectRequest.key());
        request.setResourcePath(uriResourcePath);
        if (getObjectRequest.responseCacheControl() != null) {
            request.addParameter("response-cache-control", StringConversion.fromString((String)getObjectRequest.responseCacheControl()));
        }
        if (getObjectRequest.responseContentDisposition() != null) {
            request.addParameter("response-content-disposition", StringConversion.fromString((String)getObjectRequest.responseContentDisposition()));
        }
        if (getObjectRequest.responseContentEncoding() != null) {
            request.addParameter("response-content-encoding", StringConversion.fromString((String)getObjectRequest.responseContentEncoding()));
        }
        if (getObjectRequest.responseContentLanguage() != null) {
            request.addParameter("response-content-language", StringConversion.fromString((String)getObjectRequest.responseContentLanguage()));
        }
        if (getObjectRequest.responseContentType() != null) {
            request.addParameter("response-content-type", StringConversion.fromString((String)getObjectRequest.responseContentType()));
        }
        if (getObjectRequest.responseExpires() != null) {
            request.addParameter("response-expires", StringConversion.fromInstant((Instant)getObjectRequest.responseExpires()));
        }
        if (getObjectRequest.versionId() != null) {
            request.addParameter("versionId", StringConversion.fromString((String)getObjectRequest.versionId()));
        }
        if (getObjectRequest.partNumber() != null) {
            request.addParameter("partNumber", StringConversion.fromInteger((Integer)getObjectRequest.partNumber()));
        }
        return request;
    }
}

