/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.CommonPrefix;

public class CommonPrefixUnmarshaller
implements Unmarshaller<CommonPrefix, StaxUnmarshallerContext> {
    private static final CommonPrefixUnmarshaller INSTANCE = new CommonPrefixUnmarshaller();

    public CommonPrefix unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        CommonPrefix.Builder commonPrefix = CommonPrefix.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (!context.testExpression("Prefix", targetDepth)) continue;
                commonPrefix.prefix(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (CommonPrefix)commonPrefix.build();
    }

    public static CommonPrefixUnmarshaller getInstance() {
        return INSTANCE;
    }
}

