/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.s3.model.CompletedPart;
import software.amazon.awssdk.services.s3.model.CompletedPartListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CompletedMultipartUpload
implements ToCopyableBuilder<Builder, CompletedMultipartUpload> {
    private final List<CompletedPart> parts;

    private CompletedMultipartUpload(BuilderImpl builder) {
        this.parts = builder.parts;
    }

    public List<CompletedPart> parts() {
        return this.parts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.parts());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompletedMultipartUpload)) {
            return false;
        }
        CompletedMultipartUpload other = (CompletedMultipartUpload)obj;
        return Objects.equals(this.parts(), other.parts());
    }

    public String toString() {
        return ToString.builder((String)"CompletedMultipartUpload").add("Parts", this.parts()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Parts": {
                return Optional.ofNullable(clazz.cast(this.parts()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<CompletedPart> parts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CompletedMultipartUpload model) {
            this.parts(model.parts);
        }

        public final Collection<CompletedPart.Builder> getParts() {
            return this.parts != null ? (Collection)this.parts.stream().map(CompletedPart::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parts(Collection<CompletedPart> parts) {
            this.parts = CompletedPartListCopier.copy(parts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parts(CompletedPart ... parts) {
            this.parts(Arrays.asList(parts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parts(Consumer<CompletedPart.Builder> ... parts) {
            this.parts(Stream.of(parts).map(c -> (CompletedPart)((CompletedPart.Builder)CompletedPart.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setParts(Collection<CompletedPart.BuilderImpl> parts) {
            this.parts = CompletedPartListCopier.copyFromBuilder(parts);
        }

        public CompletedMultipartUpload build() {
            return new CompletedMultipartUpload(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CompletedMultipartUpload> {
        public Builder parts(Collection<CompletedPart> var1);

        public Builder parts(CompletedPart ... var1);

        public Builder parts(Consumer<CompletedPart.Builder> ... var1);
    }
}

