/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.Tag;
import software.amazon.awssdk.services.s3.model.Tagging;
import software.amazon.awssdk.services.s3.transform.TagUnmarshaller;

public class TaggingUnmarshaller
implements Unmarshaller<Tagging, StaxUnmarshallerContext> {
    private static TaggingUnmarshaller INSTANCE;

    public Tagging unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        Tagging.Builder tagging = Tagging.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("TagSet", targetDepth)) {
                    tagging.tagSet(new ArrayList<Tag>());
                    continue;
                }
                if (!context.testExpression("TagSet/Tag", targetDepth)) continue;
                tagging.tagSet(TagUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (Tagging)tagging.build();
    }

    public static TaggingUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TaggingUnmarshaller();
        }
        return INSTANCE;
    }
}

