/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.PathMarshallers;
import software.amazon.awssdk.services.s3.model.Condition;
import software.amazon.awssdk.services.s3.model.ErrorDocument;
import software.amazon.awssdk.services.s3.model.IndexDocument;
import software.amazon.awssdk.services.s3.model.PutBucketWebsiteRequest;
import software.amazon.awssdk.services.s3.model.Redirect;
import software.amazon.awssdk.services.s3.model.RedirectAllRequestsTo;
import software.amazon.awssdk.services.s3.model.RoutingRule;
import software.amazon.awssdk.services.s3.model.WebsiteConfiguration;
import software.amazon.awssdk.util.Md5Utils;
import software.amazon.awssdk.util.StringInputStream;
import software.amazon.awssdk.util.StringUtils;
import software.amazon.awssdk.util.UriResourcePathUtils;
import software.amazon.awssdk.util.XmlWriter;

public class PutBucketWebsiteRequestMarshaller
implements Marshaller<Request<PutBucketWebsiteRequest>, PutBucketWebsiteRequest> {
    public Request<PutBucketWebsiteRequest> marshall(PutBucketWebsiteRequest putBucketWebsiteRequest) {
        if (putBucketWebsiteRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putBucketWebsiteRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.PUT);
        if (putBucketWebsiteRequest.contentMD5() != null) {
            request.addHeader("Content-MD5", StringUtils.fromString((String)putBucketWebsiteRequest.contentMD5()));
        }
        String uriResourcePath = "/{Bucket}?website";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParamtersToRequest((Request)request, (String)uriResourcePath);
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", putBucketWebsiteRequest.bucket());
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = null;
            WebsiteConfiguration websiteConfiguration = putBucketWebsiteRequest.websiteConfiguration();
            if (websiteConfiguration != null) {
                List<RoutingRule> websiteConfigurationRoutingRulesList;
                RedirectAllRequestsTo redirectAllRequestsTo;
                IndexDocument indexDocument;
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter((Writer)stringWriter, "http://s3.amazonaws.com/doc/2006-03-01/");
                xmlWriter.startElement("WebsiteConfiguration");
                ErrorDocument errorDocument = websiteConfiguration.errorDocument();
                if (errorDocument != null) {
                    xmlWriter.startElement("ErrorDocument");
                    if (errorDocument.key() != null) {
                        xmlWriter.startElement("Key").value(errorDocument.key()).endElement();
                    }
                    xmlWriter.endElement();
                }
                if ((indexDocument = websiteConfiguration.indexDocument()) != null) {
                    xmlWriter.startElement("IndexDocument");
                    if (indexDocument.suffix() != null) {
                        xmlWriter.startElement("Suffix").value(indexDocument.suffix()).endElement();
                    }
                    xmlWriter.endElement();
                }
                if ((redirectAllRequestsTo = websiteConfiguration.redirectAllRequestsTo()) != null) {
                    xmlWriter.startElement("RedirectAllRequestsTo");
                    if (redirectAllRequestsTo.hostName() != null) {
                        xmlWriter.startElement("HostName").value(redirectAllRequestsTo.hostName()).endElement();
                    }
                    if (redirectAllRequestsTo.protocol() != null) {
                        xmlWriter.startElement("Protocol").value(redirectAllRequestsTo.protocol()).endElement();
                    }
                    xmlWriter.endElement();
                }
                if ((websiteConfigurationRoutingRulesList = websiteConfiguration.routingRules()) != null) {
                    xmlWriter.startElement("RoutingRules");
                    for (RoutingRule websiteConfigurationRoutingRulesListValue : websiteConfigurationRoutingRulesList) {
                        Redirect redirect;
                        xmlWriter.startElement("RoutingRule");
                        Condition condition = websiteConfigurationRoutingRulesListValue.condition();
                        if (condition != null) {
                            xmlWriter.startElement("Condition");
                            if (condition.httpErrorCodeReturnedEquals() != null) {
                                xmlWriter.startElement("HttpErrorCodeReturnedEquals").value(condition.httpErrorCodeReturnedEquals()).endElement();
                            }
                            if (condition.keyPrefixEquals() != null) {
                                xmlWriter.startElement("KeyPrefixEquals").value(condition.keyPrefixEquals()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if ((redirect = websiteConfigurationRoutingRulesListValue.redirect()) != null) {
                            xmlWriter.startElement("Redirect");
                            if (redirect.hostName() != null) {
                                xmlWriter.startElement("HostName").value(redirect.hostName()).endElement();
                            }
                            if (redirect.httpRedirectCode() != null) {
                                xmlWriter.startElement("HttpRedirectCode").value(redirect.httpRedirectCode()).endElement();
                            }
                            if (redirect.protocol() != null) {
                                xmlWriter.startElement("Protocol").value(redirect.protocol()).endElement();
                            }
                            if (redirect.replaceKeyPrefixWith() != null) {
                                xmlWriter.startElement("ReplaceKeyPrefixWith").value(redirect.replaceKeyPrefixWith()).endElement();
                            }
                            if (redirect.replaceKeyWith() != null) {
                                xmlWriter.startElement("ReplaceKeyWith").value(redirect.replaceKeyWith()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }
            if (stringWriter != null) {
                if (!request.getHeaders().containsKey("Content-MD5")) {
                    request.addHeader("Content-MD5", Md5Utils.md5AsBase64((byte[])stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8)));
                }
                request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

