/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.PathMarshallers;
import software.amazon.awssdk.services.s3.model.CloudFunctionConfiguration;
import software.amazon.awssdk.services.s3.model.NotificationConfigurationDeprecated;
import software.amazon.awssdk.services.s3.model.PutBucketNotificationRequest;
import software.amazon.awssdk.services.s3.model.QueueConfigurationDeprecated;
import software.amazon.awssdk.services.s3.model.TopicConfigurationDeprecated;
import software.amazon.awssdk.util.Md5Utils;
import software.amazon.awssdk.util.StringInputStream;
import software.amazon.awssdk.util.StringUtils;
import software.amazon.awssdk.util.UriResourcePathUtils;
import software.amazon.awssdk.util.XmlWriter;

public class PutBucketNotificationRequestMarshaller
implements Marshaller<Request<PutBucketNotificationRequest>, PutBucketNotificationRequest> {
    public Request<PutBucketNotificationRequest> marshall(PutBucketNotificationRequest putBucketNotificationRequest) {
        if (putBucketNotificationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putBucketNotificationRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.PUT);
        if (putBucketNotificationRequest.contentMD5() != null) {
            request.addHeader("Content-MD5", StringUtils.fromString((String)putBucketNotificationRequest.contentMD5()));
        }
        String uriResourcePath = "/{Bucket}?notification";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParamtersToRequest((Request)request, (String)uriResourcePath);
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", putBucketNotificationRequest.bucket());
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = null;
            NotificationConfigurationDeprecated notificationConfiguration = putBucketNotificationRequest.notificationConfiguration();
            if (notificationConfiguration != null) {
                CloudFunctionConfiguration cloudFunctionConfiguration;
                QueueConfigurationDeprecated queueConfiguration;
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter((Writer)stringWriter, "http://s3.amazonaws.com/doc/2006-03-01/");
                xmlWriter.startElement("NotificationConfiguration");
                TopicConfigurationDeprecated topicConfiguration = notificationConfiguration.topicConfiguration();
                if (topicConfiguration != null) {
                    List<String> topicConfigurationDeprecatedEventsList;
                    xmlWriter.startElement("TopicConfiguration");
                    if (topicConfiguration.id() != null) {
                        xmlWriter.startElement("Id").value(topicConfiguration.id()).endElement();
                    }
                    if ((topicConfigurationDeprecatedEventsList = topicConfiguration.events()) != null) {
                        for (String string : topicConfigurationDeprecatedEventsList) {
                            xmlWriter.startElement("Event");
                            xmlWriter.value(string);
                            xmlWriter.endElement();
                        }
                    }
                    if (topicConfiguration.event() != null) {
                        xmlWriter.startElement("Event").value(topicConfiguration.event()).endElement();
                    }
                    if (topicConfiguration.topic() != null) {
                        xmlWriter.startElement("Topic").value(topicConfiguration.topic()).endElement();
                    }
                    xmlWriter.endElement();
                }
                if ((queueConfiguration = notificationConfiguration.queueConfiguration()) != null) {
                    List<String> queueConfigurationDeprecatedEventsList;
                    xmlWriter.startElement("QueueConfiguration");
                    if (queueConfiguration.id() != null) {
                        xmlWriter.startElement("Id").value(queueConfiguration.id()).endElement();
                    }
                    if (queueConfiguration.event() != null) {
                        xmlWriter.startElement("Event").value(queueConfiguration.event()).endElement();
                    }
                    if ((queueConfigurationDeprecatedEventsList = queueConfiguration.events()) != null) {
                        for (String queueConfigurationDeprecatedEventsListValue : queueConfigurationDeprecatedEventsList) {
                            xmlWriter.startElement("Event");
                            xmlWriter.value(queueConfigurationDeprecatedEventsListValue);
                            xmlWriter.endElement();
                        }
                    }
                    if (queueConfiguration.queue() != null) {
                        xmlWriter.startElement("Queue").value(queueConfiguration.queue()).endElement();
                    }
                    xmlWriter.endElement();
                }
                if ((cloudFunctionConfiguration = notificationConfiguration.cloudFunctionConfiguration()) != null) {
                    List<String> list;
                    xmlWriter.startElement("CloudFunctionConfiguration");
                    if (cloudFunctionConfiguration.id() != null) {
                        xmlWriter.startElement("Id").value(cloudFunctionConfiguration.id()).endElement();
                    }
                    if (cloudFunctionConfiguration.event() != null) {
                        xmlWriter.startElement("Event").value(cloudFunctionConfiguration.event()).endElement();
                    }
                    if ((list = cloudFunctionConfiguration.events()) != null) {
                        for (String cloudFunctionConfigurationEventsListValue : list) {
                            xmlWriter.startElement("Event");
                            xmlWriter.value(cloudFunctionConfigurationEventsListValue);
                            xmlWriter.endElement();
                        }
                    }
                    if (cloudFunctionConfiguration.cloudFunction() != null) {
                        xmlWriter.startElement("CloudFunction").value(cloudFunctionConfiguration.cloudFunction()).endElement();
                    }
                    if (cloudFunctionConfiguration.invocationRole() != null) {
                        xmlWriter.startElement("InvocationRole").value(cloudFunctionConfiguration.invocationRole()).endElement();
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }
            if (stringWriter != null) {
                if (!request.getHeaders().containsKey("Content-MD5")) {
                    request.addHeader("Content-MD5", Md5Utils.md5AsBase64((byte[])stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8)));
                }
                request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

