/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.PathMarshallers;
import software.amazon.awssdk.services.s3.model.ListBucketMetricsConfigurationsRequest;
import software.amazon.awssdk.util.StringUtils;
import software.amazon.awssdk.util.UriResourcePathUtils;

public class ListBucketMetricsConfigurationsRequestMarshaller
implements Marshaller<Request<ListBucketMetricsConfigurationsRequest>, ListBucketMetricsConfigurationsRequest> {
    public Request<ListBucketMetricsConfigurationsRequest> marshall(ListBucketMetricsConfigurationsRequest listBucketMetricsConfigurationsRequest) {
        if (listBucketMetricsConfigurationsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listBucketMetricsConfigurationsRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/{Bucket}?metrics";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParamtersToRequest((Request)request, (String)uriResourcePath);
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", listBucketMetricsConfigurationsRequest.bucket());
        request.setResourcePath(uriResourcePath);
        if (listBucketMetricsConfigurationsRequest.continuationToken() != null) {
            request.addParameter("continuation-token", StringUtils.fromString((String)listBucketMetricsConfigurationsRequest.continuationToken()));
        }
        return request;
    }
}

