/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.PathMarshallers;
import software.amazon.awssdk.services.s3.model.GetBucketMetricsConfigurationRequest;
import software.amazon.awssdk.util.StringUtils;
import software.amazon.awssdk.util.UriResourcePathUtils;

public class GetBucketMetricsConfigurationRequestMarshaller
implements Marshaller<Request<GetBucketMetricsConfigurationRequest>, GetBucketMetricsConfigurationRequest> {
    public Request<GetBucketMetricsConfigurationRequest> marshall(GetBucketMetricsConfigurationRequest getBucketMetricsConfigurationRequest) {
        if (getBucketMetricsConfigurationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getBucketMetricsConfigurationRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/{Bucket}?metrics";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParamtersToRequest((Request)request, (String)uriResourcePath);
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", getBucketMetricsConfigurationRequest.bucket());
        request.setResourcePath(uriResourcePath);
        if (getBucketMetricsConfigurationRequest.id() != null) {
            request.addParameter("id", StringUtils.fromString((String)getBucketMetricsConfigurationRequest.id()));
        }
        return request;
    }
}

