/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.PathMarshallers;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.util.StringUtils;

public class DeleteObjectRequestMarshaller
implements Marshaller<Request<DeleteObjectRequest>, DeleteObjectRequest> {
    public Request<DeleteObjectRequest> marshall(DeleteObjectRequest deleteObjectRequest) {
        if (deleteObjectRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteObjectRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.DELETE);
        if (deleteObjectRequest.mfa() != null) {
            request.addHeader("x-amz-mfa", StringUtils.fromString((String)deleteObjectRequest.mfa()));
        }
        if (deleteObjectRequest.requestPayer() != null) {
            request.addHeader("x-amz-request-payer", StringUtils.fromString((String)deleteObjectRequest.requestPayer()));
        }
        String uriResourcePath = "/{Bucket}/{Key+}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", deleteObjectRequest.bucket());
        uriResourcePath = PathMarshallers.GREEDY.marshall(uriResourcePath, "Key", deleteObjectRequest.key());
        request.setResourcePath(uriResourcePath);
        if (deleteObjectRequest.versionId() != null) {
            request.addParameter("versionId", StringUtils.fromString((String)deleteObjectRequest.versionId()));
        }
        return request;
    }
}

