/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadResponse;
import software.amazon.awssdk.util.DateUtils;

public class CreateMultipartUploadResponseUnmarshaller
implements Unmarshaller<CreateMultipartUploadResponse, StaxUnmarshallerContext> {
    private static CreateMultipartUploadResponseUnmarshaller INSTANCE;

    public CreateMultipartUploadResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        CreateMultipartUploadResponse.Builder createMultipartUploadResponse = CreateMultipartUploadResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        if (context.isStartOfDocument()) {
            context.setCurrentHeader("x-amz-abort-date");
            createMultipartUploadResponse.abortDate(DateUtils.parseRfc822Date((String)context.readText()));
            context.setCurrentHeader("x-amz-abort-rule-id");
            createMultipartUploadResponse.abortRuleId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("x-amz-server-side-encryption");
            createMultipartUploadResponse.serverSideEncryption(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("x-amz-server-side-encryption-customer-algorithm");
            createMultipartUploadResponse.sseCustomerAlgorithm(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("x-amz-server-side-encryption-customer-key-MD5");
            createMultipartUploadResponse.sseCustomerKeyMD5(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("x-amz-server-side-encryption-aws-kms-key-id");
            createMultipartUploadResponse.ssekmsKeyId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("x-amz-request-charged");
            createMultipartUploadResponse.requestCharged(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Bucket", targetDepth)) {
                    createMultipartUploadResponse.bucket(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Key", targetDepth)) {
                    createMultipartUploadResponse.key(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("UploadId", targetDepth)) continue;
                createMultipartUploadResponse.uploadId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (CreateMultipartUploadResponse)((Object)createMultipartUploadResponse.build());
    }

    public static CreateMultipartUploadResponseUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CreateMultipartUploadResponseUnmarshaller();
        }
        return INSTANCE;
    }
}

