/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.CORSConfiguration;
import software.amazon.awssdk.services.s3.transform.CORSRuleUnmarshaller;

public class CORSConfigurationUnmarshaller
implements Unmarshaller<CORSConfiguration, StaxUnmarshallerContext> {
    private static CORSConfigurationUnmarshaller INSTANCE;

    public CORSConfiguration unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        CORSConfiguration.Builder corsConfiguration = CORSConfiguration.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (!context.testExpression("CORSRule", targetDepth)) continue;
                corsConfiguration.corsRules(CORSRuleUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (CORSConfiguration)corsConfiguration.build();
    }

    public static CORSConfigurationUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CORSConfigurationUnmarshaller();
        }
        return INSTANCE;
    }
}

