/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.s3.model.Tag;
import software.amazon.awssdk.services.s3.model.TagSetCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetObjectTaggingResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetObjectTaggingResponse> {
    private final String versionId;
    private final List<Tag> tagSet;

    private GetObjectTaggingResponse(BuilderImpl builder) {
        this.versionId = builder.versionId;
        this.tagSet = builder.tagSet;
    }

    public String versionId() {
        return this.versionId;
    }

    public List<Tag> tagSet() {
        return this.tagSet;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.versionId() == null ? 0 : this.versionId().hashCode());
        hashCode = 31 * hashCode + (this.tagSet() == null ? 0 : this.tagSet().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetObjectTaggingResponse)) {
            return false;
        }
        GetObjectTaggingResponse other = (GetObjectTaggingResponse)((Object)obj);
        if (other.versionId() == null ^ this.versionId() == null) {
            return false;
        }
        if (other.versionId() != null && !other.versionId().equals(this.versionId())) {
            return false;
        }
        if (other.tagSet() == null ^ this.tagSet() == null) {
            return false;
        }
        return other.tagSet() == null || other.tagSet().equals(this.tagSet());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.versionId() != null) {
            sb.append("VersionId: ").append(this.versionId()).append(",");
        }
        if (this.tagSet() != null) {
            sb.append("TagSet: ").append(this.tagSet()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String versionId;
        private List<Tag> tagSet;

        private BuilderImpl() {
        }

        private BuilderImpl(GetObjectTaggingResponse model) {
            this.setVersionId(model.versionId);
            this.setTagSet(model.tagSet);
        }

        public final String getVersionId() {
            return this.versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        public final Collection<Tag> getTagSet() {
            return this.tagSet;
        }

        @Override
        public final Builder tagSet(Collection<Tag> tagSet) {
            this.tagSet = TagSetCopier.copy(tagSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSet(Tag ... tagSet) {
            if (this.tagSet == null) {
                this.tagSet = new ArrayList<Tag>(tagSet.length);
            }
            for (Tag e : tagSet) {
                this.tagSet.add(e);
            }
            return this;
        }

        public final void setTagSet(Collection<Tag> tagSet) {
            this.tagSet = TagSetCopier.copy(tagSet);
        }

        @SafeVarargs
        public final void setTagSet(Tag ... tagSet) {
            if (this.tagSet == null) {
                this.tagSet = new ArrayList<Tag>(tagSet.length);
            }
            for (Tag e : tagSet) {
                this.tagSet.add(e);
            }
        }

        public GetObjectTaggingResponse build() {
            return new GetObjectTaggingResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetObjectTaggingResponse> {
        public Builder versionId(String var1);

        public Builder tagSet(Collection<Tag> var1);

        public Builder tagSet(Tag ... var1);
    }
}

