/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import software.amazon.awssdk.services.s3.model.AnalyticsFilter;
import software.amazon.awssdk.services.s3.model.StorageClassAnalysis;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AnalyticsConfiguration
implements ToCopyableBuilder<Builder, AnalyticsConfiguration> {
    private final String id;
    private final AnalyticsFilter filter;
    private final StorageClassAnalysis storageClassAnalysis;

    private AnalyticsConfiguration(BuilderImpl builder) {
        this.id = builder.id;
        this.filter = builder.filter;
        this.storageClassAnalysis = builder.storageClassAnalysis;
    }

    public String id() {
        return this.id;
    }

    public AnalyticsFilter filter() {
        return this.filter;
    }

    public StorageClassAnalysis storageClassAnalysis() {
        return this.storageClassAnalysis;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.filter() == null ? 0 : this.filter().hashCode());
        hashCode = 31 * hashCode + (this.storageClassAnalysis() == null ? 0 : this.storageClassAnalysis().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalyticsConfiguration)) {
            return false;
        }
        AnalyticsConfiguration other = (AnalyticsConfiguration)obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.filter() == null ^ this.filter() == null) {
            return false;
        }
        if (other.filter() != null && !other.filter().equals(this.filter())) {
            return false;
        }
        if (other.storageClassAnalysis() == null ^ this.storageClassAnalysis() == null) {
            return false;
        }
        return other.storageClassAnalysis() == null || other.storageClassAnalysis().equals(this.storageClassAnalysis());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.filter() != null) {
            sb.append("Filter: ").append(this.filter()).append(",");
        }
        if (this.storageClassAnalysis() != null) {
            sb.append("StorageClassAnalysis: ").append(this.storageClassAnalysis()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String id;
        private AnalyticsFilter filter;
        private StorageClassAnalysis storageClassAnalysis;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalyticsConfiguration model) {
            this.setId(model.id);
            this.setFilter(model.filter);
            this.setStorageClassAnalysis(model.storageClassAnalysis);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final AnalyticsFilter getFilter() {
            return this.filter;
        }

        @Override
        public final Builder filter(AnalyticsFilter filter) {
            this.filter = filter;
            return this;
        }

        public final void setFilter(AnalyticsFilter filter) {
            this.filter = filter;
        }

        public final StorageClassAnalysis getStorageClassAnalysis() {
            return this.storageClassAnalysis;
        }

        @Override
        public final Builder storageClassAnalysis(StorageClassAnalysis storageClassAnalysis) {
            this.storageClassAnalysis = storageClassAnalysis;
            return this;
        }

        public final void setStorageClassAnalysis(StorageClassAnalysis storageClassAnalysis) {
            this.storageClassAnalysis = storageClassAnalysis;
        }

        public AnalyticsConfiguration build() {
            return new AnalyticsConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AnalyticsConfiguration> {
        public Builder id(String var1);

        public Builder filter(AnalyticsFilter var1);

        public Builder storageClassAnalysis(StorageClassAnalysis var1);
    }
}

