/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.handlers;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import software.amazon.awssdk.RequestConfig;
import software.amazon.awssdk.annotation.ReviewBeforeRelease;
import software.amazon.awssdk.handlers.AwsHandlerKeys;
import software.amazon.awssdk.handlers.RequestHandler;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.services.s3.BucketUtils;
import software.amazon.awssdk.services.s3.S3AdvancedConfiguration;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketRequest;
import software.amazon.awssdk.services.s3.model.ListBucketsRequest;
import software.amazon.awssdk.utils.FunctionalUtils;

public class EndpointAddressRequestHandler
extends RequestHandler {
    private static List<Class> ACCELERATE_DISABLED_OPERATIONS = Arrays.asList(ListBucketsRequest.class, CreateBucketRequest.class, DeleteBucketRequest.class);

    public SdkHttpFullRequest beforeRequest(SdkHttpFullRequest request) {
        S3AdvancedConfiguration advancedConfiguration = (S3AdvancedConfiguration)request.handlerContext(AwsHandlerKeys.SERVICE_ADVANCED_CONFIG);
        Object originalRequest = ((RequestConfig)request.handlerContext(AwsHandlerKeys.REQUEST_CONFIG)).getOriginalRequest();
        SdkHttpFullRequest.Builder mutableRequest = (SdkHttpFullRequest.Builder)request.toBuilder();
        if (advancedConfiguration == null || !advancedConfiguration.pathStyleAccessEnabled()) {
            try {
                String bucketName = this.getBucketName(originalRequest);
                if (BucketUtils.isValidDnsBucketName(bucketName, false)) {
                    this.changeToDnsEndpoint(mutableRequest, bucketName);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (advancedConfiguration != null && advancedConfiguration.accelerateModeEnabled() && ACCELERATE_DISABLED_OPERATIONS.contains(originalRequest.getClass())) {
            this.removeAccelerate(mutableRequest);
        }
        return (SdkHttpFullRequest)mutableRequest.build();
    }

    @ReviewBeforeRelease(value="Remove reflection here. Have some kind of interface where we can get bucket name or pass itin the handler context")
    private String getBucketName(Object originalRequest) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return (String)originalRequest.getClass().getMethod("bucket", new Class[0]).invoke(originalRequest, new Object[0]);
    }

    private void removeAccelerate(SdkHttpFullRequest.Builder mutableRequest) {
        mutableRequest.endpoint(URI.create(mutableRequest.getEndpoint().toASCIIString().replaceFirst("s3-accelerate", "s3")));
    }

    private void changeToDnsEndpoint(SdkHttpFullRequest.Builder mutableRequest, String bucketName) {
        String resourcePath = mutableRequest.getResourcePath().replaceFirst("/" + bucketName, "");
        URI endpoint = (URI)FunctionalUtils.invokeSafely(() -> new URI(mutableRequest.getEndpoint().getScheme(), mutableRequest.getEndpoint().getHost().replaceFirst("s3", bucketName + ".s3"), null, null));
        mutableRequest.endpoint(endpoint);
        mutableRequest.resourcePath(resourcePath);
    }
}

