/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3;

import java.net.URI;
import java.net.URISyntaxException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.RegionMetadata;
import software.amazon.awssdk.runtime.endpoint.DefaultServiceEndpointBuilder;
import software.amazon.awssdk.services.s3.S3AdvancedConfiguration;

public class S3ServiceEndpointBuilder {
    public static URI getEndpoint(S3AdvancedConfiguration advancedConfiguration, Region region) {
        RegionMetadata metadata = RegionMetadata.of((Region)region);
        if (advancedConfiguration != null && advancedConfiguration.dualstackEnabled()) {
            return S3ServiceEndpointBuilder.dualstackEndpoint(metadata);
        }
        if (advancedConfiguration != null && advancedConfiguration.accelerateModeEnabled()) {
            return S3ServiceEndpointBuilder.accelerateEndpoint(advancedConfiguration, metadata);
        }
        return new DefaultServiceEndpointBuilder("s3", "https").withRegion(region).getServiceEndpoint();
    }

    private static URI dualstackEndpoint(RegionMetadata metadata) {
        String serviceEndpoint = String.format("%s.%s.%s.%s", "s3", "dualstack", metadata.getName(), metadata.getDomain());
        return S3ServiceEndpointBuilder.toUri(serviceEndpoint);
    }

    private static URI accelerateEndpoint(S3AdvancedConfiguration advancedConfiguration, RegionMetadata metadata) {
        if (advancedConfiguration.dualstackEnabled()) {
            return S3ServiceEndpointBuilder.toUri("s3-accelerate.dualstack." + metadata.getDomain());
        }
        return S3ServiceEndpointBuilder.toUri("s3-accelerate." + metadata.getDomain());
    }

    private static URI toUri(String endpoint) throws IllegalArgumentException {
        try {
            return new URI(String.format("%s://%s", "https", endpoint));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

