/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3.internal.progress;

import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.transfer.s3.model.CompletedObjectTransfer;
import software.amazon.awssdk.transfer.s3.model.TransferObjectRequest;
import software.amazon.awssdk.transfer.s3.progress.TransferListener;
import software.amazon.awssdk.transfer.s3.progress.TransferProgressSnapshot;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkProtectedApi
@Immutable
public final class TransferListenerContext
implements TransferListener.Context.TransferComplete,
ToCopyableBuilder<Builder, TransferListenerContext> {
    private final TransferObjectRequest request;
    private final TransferProgressSnapshot progressSnapshot;
    private final CompletedObjectTransfer completedTransfer;

    private TransferListenerContext(Builder builder) {
        this.request = builder.request;
        this.progressSnapshot = builder.progressSnapshot;
        this.completedTransfer = builder.completedTransfer;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public TransferObjectRequest request() {
        return this.request;
    }

    @Override
    public TransferProgressSnapshot progressSnapshot() {
        return this.progressSnapshot;
    }

    @Override
    public CompletedObjectTransfer completedTransfer() {
        return this.completedTransfer;
    }

    public String toString() {
        return ToString.builder((String)"TransferListenerContext").add("request", (Object)this.request).add("progressSnapshot", (Object)this.progressSnapshot).add("completedTransfer", (Object)this.completedTransfer).build();
    }

    public static final class Builder
    implements CopyableBuilder<Builder, TransferListenerContext> {
        private TransferObjectRequest request;
        private TransferProgressSnapshot progressSnapshot;
        private CompletedObjectTransfer completedTransfer;

        private Builder() {
        }

        private Builder(TransferListenerContext context) {
            this.request = context.request;
            this.progressSnapshot = context.progressSnapshot;
            this.completedTransfer = context.completedTransfer;
        }

        public Builder request(TransferObjectRequest request) {
            this.request = request;
            return this;
        }

        public Builder progressSnapshot(TransferProgressSnapshot progressSnapshot) {
            this.progressSnapshot = progressSnapshot;
            return this;
        }

        public Builder completedTransfer(CompletedObjectTransfer completedTransfer) {
            this.completedTransfer = completedTransfer;
            return this;
        }

        public TransferListenerContext build() {
            return new TransferListenerContext(this);
        }
    }
}

