/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3.progress;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.concurrent.atomic.AtomicInteger;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.transfer.s3.progress.TransferListener;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.StringUtils;

@SdkPublicApi
public final class LoggingTransferListener
implements TransferListener {
    private static final Logger log = Logger.loggerFor(LoggingTransferListener.class);
    private static final int DEFAULT_MAX_TICKS = 20;
    private final ProgressBar progressBar;

    private LoggingTransferListener(int maxTicks) {
        this.progressBar = new ProgressBar(maxTicks);
    }

    public static LoggingTransferListener create(int maxTicks) {
        return new LoggingTransferListener(maxTicks);
    }

    public static LoggingTransferListener create() {
        return new LoggingTransferListener(20);
    }

    @Override
    public void transferInitiated(TransferListener.Context.TransferInitiated context) {
        log.info(() -> "Transfer initiated...");
        context.progressSnapshot().ratioTransferred().ifPresent(this.progressBar::update);
    }

    @Override
    public void bytesTransferred(TransferListener.Context.BytesTransferred context) {
        context.progressSnapshot().ratioTransferred().ifPresent(this.progressBar::update);
    }

    @Override
    public void transferComplete(TransferListener.Context.TransferComplete context) {
        context.progressSnapshot().ratioTransferred().ifPresent(this.progressBar::update);
        log.info(() -> "Transfer complete!");
    }

    @Override
    public void transferFailed(TransferListener.Context.TransferFailed context) {
        log.warn(() -> "Transfer failed.", context.exception());
    }

    private static class ProgressBar {
        private final int maxTicks;
        private final AtomicInteger prevTicks = new AtomicInteger(-1);

        ProgressBar(int maxTicks) {
            this.maxTicks = maxTicks;
        }

        void update(double ratio) {
            int ticks = (int)Math.floor(ratio * (double)this.maxTicks);
            if (this.prevTicks.getAndSet(ticks) != ticks) {
                log.info(() -> String.format("|%s%s| %s", StringUtils.repeat((String)"=", (int)ticks), StringUtils.repeat((String)" ", (int)(this.maxTicks - ticks)), ProgressBar.round(ratio * 100.0, 1) + "%"));
            }
        }

        private static double round(double value, int places) {
            BigDecimal bd = BigDecimal.valueOf(value);
            bd = bd.setScale(places, RoundingMode.FLOOR);
            return bd.doubleValue();
        }
    }
}

