/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3.internal.progress;

import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkResponse;
import software.amazon.awssdk.transfer.s3.progress.TransferProgressSnapshot;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkInternalApi
public final class DefaultTransferProgressSnapshot
implements ToCopyableBuilder<Builder, DefaultTransferProgressSnapshot>,
TransferProgressSnapshot {
    private final long transferredBytes;
    private final Long totalBytes;
    private final SdkResponse sdkResponse;

    private DefaultTransferProgressSnapshot(Builder builder) {
        if (builder.totalBytes != null) {
            Validate.isNotNegative((long)builder.totalBytes, (String)"totalBytes");
            Validate.isTrue((builder.transferredBytes <= builder.totalBytes ? 1 : 0) != 0, (String)"transferredBytes (%s) must not be greater than totalBytes (%s)", (Object[])new Object[]{builder.transferredBytes, builder.totalBytes});
        }
        Validate.paramNotNull((Object)builder.transferredBytes, (String)"byteTransferred");
        this.transferredBytes = Validate.isNotNegative((long)builder.transferredBytes, (String)"transferredBytes");
        this.totalBytes = builder.totalBytes;
        this.sdkResponse = builder.sdkResponse;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public long transferredBytes() {
        return this.transferredBytes;
    }

    @Override
    public OptionalLong totalBytes() {
        return this.totalBytes == null ? OptionalLong.empty() : OptionalLong.of(this.totalBytes);
    }

    @Override
    public Optional<SdkResponse> sdkResponse() {
        return Optional.ofNullable(this.sdkResponse);
    }

    @Override
    public OptionalDouble ratioTransferred() {
        if (this.totalBytes == null) {
            return OptionalDouble.empty();
        }
        return this.totalBytes == 0L ? OptionalDouble.of(1.0) : OptionalDouble.of((double)this.transferredBytes / this.totalBytes.doubleValue());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultTransferProgressSnapshot that = (DefaultTransferProgressSnapshot)o;
        if (this.transferredBytes != that.transferredBytes) {
            return false;
        }
        if (!Objects.equals(this.totalBytes, that.totalBytes)) {
            return false;
        }
        return Objects.equals(this.sdkResponse, that.sdkResponse);
    }

    public int hashCode() {
        int result = (int)(this.transferredBytes ^ this.transferredBytes >>> 32);
        result = 31 * result + (this.totalBytes != null ? this.totalBytes.hashCode() : 0);
        result = 31 * result + (this.sdkResponse != null ? this.sdkResponse.hashCode() : 0);
        return result;
    }

    @Override
    public OptionalLong remainingBytes() {
        if (this.totalBytes == null) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(this.totalBytes - this.transferredBytes);
    }

    public String toString() {
        return ToString.builder((String)"TransferProgressSnapshot").add("transferredBytes", (Object)this.transferredBytes).add("totalBytes", (Object)this.totalBytes).add("sdkResponse", (Object)this.sdkResponse).build();
    }

    public static final class Builder
    implements CopyableBuilder<Builder, DefaultTransferProgressSnapshot> {
        private Long transferredBytes;
        private Long totalBytes;
        private SdkResponse sdkResponse;

        private Builder() {
        }

        private Builder(DefaultTransferProgressSnapshot snapshot) {
            this.transferredBytes = snapshot.transferredBytes;
            this.totalBytes = snapshot.totalBytes;
            this.sdkResponse = snapshot.sdkResponse;
        }

        public Builder transferredBytes(Long transferredBytes) {
            this.transferredBytes = transferredBytes;
            return this;
        }

        public long getTransferredBytes() {
            return this.transferredBytes;
        }

        public Builder totalBytes(Long totalBytes) {
            this.totalBytes = totalBytes;
            return this;
        }

        public Long getTotalBytes() {
            return this.totalBytes;
        }

        public Builder sdkResponse(SdkResponse sdkResponse) {
            this.sdkResponse = sdkResponse;
            return this;
        }

        public DefaultTransferProgressSnapshot build() {
            return new DefaultTransferProgressSnapshot(this);
        }
    }
}

