/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3.internal;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.transfer.s3.S3TransferManager;
import software.amazon.awssdk.transfer.s3.model.Copy;
import software.amazon.awssdk.transfer.s3.model.CopyRequest;
import software.amazon.awssdk.transfer.s3.model.DirectoryDownload;
import software.amazon.awssdk.transfer.s3.model.DirectoryUpload;
import software.amazon.awssdk.transfer.s3.model.Download;
import software.amazon.awssdk.transfer.s3.model.DownloadDirectoryRequest;
import software.amazon.awssdk.transfer.s3.model.DownloadFileRequest;
import software.amazon.awssdk.transfer.s3.model.DownloadRequest;
import software.amazon.awssdk.transfer.s3.model.FileDownload;
import software.amazon.awssdk.transfer.s3.model.FileUpload;
import software.amazon.awssdk.transfer.s3.model.ResumableFileDownload;
import software.amazon.awssdk.transfer.s3.model.Upload;
import software.amazon.awssdk.transfer.s3.model.UploadDirectoryRequest;
import software.amazon.awssdk.transfer.s3.model.UploadFileRequest;
import software.amazon.awssdk.transfer.s3.model.UploadRequest;

@SdkInternalApi
abstract class DelegatingS3TransferManager
implements S3TransferManager {
    private final S3TransferManager delegate;

    protected DelegatingS3TransferManager(S3TransferManager delegate) {
        this.delegate = delegate;
    }

    @Override
    public Upload upload(UploadRequest uploadRequest) {
        return this.delegate.upload(uploadRequest);
    }

    @Override
    public FileUpload uploadFile(UploadFileRequest uploadFileRequest) {
        return this.delegate.uploadFile(uploadFileRequest);
    }

    @Override
    public DirectoryUpload uploadDirectory(UploadDirectoryRequest uploadDirectoryRequest) {
        return this.delegate.uploadDirectory(uploadDirectoryRequest);
    }

    @Override
    public <ResultT> Download<ResultT> download(DownloadRequest<ResultT> downloadRequest) {
        return this.delegate.download(downloadRequest);
    }

    @Override
    public FileDownload downloadFile(DownloadFileRequest downloadRequest) {
        return this.delegate.downloadFile(downloadRequest);
    }

    @Override
    public FileDownload resumeDownloadFile(ResumableFileDownload resumableFileDownload) {
        return this.delegate.resumeDownloadFile(resumableFileDownload);
    }

    @Override
    public DirectoryDownload downloadDirectory(DownloadDirectoryRequest downloadDirectoryRequest) {
        return this.delegate.downloadDirectory(downloadDirectoryRequest);
    }

    @Override
    public Copy copy(CopyRequest copyRequest) {
        return this.delegate.copy(copyRequest);
    }

    public void close() {
        this.delegate.close();
    }
}

