/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3.internal.progress;

import java.util.concurrent.CompletionException;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.transfer.s3.TransferObjectRequest;
import software.amazon.awssdk.transfer.s3.internal.progress.TransferListenerContext;
import software.amazon.awssdk.transfer.s3.progress.TransferListener;
import software.amazon.awssdk.transfer.s3.progress.TransferProgressSnapshot;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkInternalApi
@Immutable
public class TransferListenerFailedContext
implements TransferListener.Context.TransferFailed,
ToCopyableBuilder<Builder, TransferListenerFailedContext> {
    private final TransferListenerContext transferContext;
    private final Throwable exception;

    private TransferListenerFailedContext(Builder builder) {
        this.exception = this.unwrap((Throwable)Validate.paramNotNull((Object)builder.exception, (String)"exception"));
        this.transferContext = (TransferListenerContext)Validate.paramNotNull((Object)builder.transferContext, (String)"transferContext");
    }

    private Throwable unwrap(Throwable exception) {
        while (exception instanceof CompletionException) {
            exception = exception.getCause();
        }
        return exception;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public TransferObjectRequest request() {
        return this.transferContext.request();
    }

    @Override
    public TransferProgressSnapshot progressSnapshot() {
        return this.transferContext.progressSnapshot();
    }

    @Override
    public Throwable exception() {
        return this.exception;
    }

    public String toString() {
        return ToString.builder((String)"TransferListenerFailedContext").add("transferContext", (Object)this.transferContext).add("exception", (Object)this.exception).build();
    }

    public static final class Builder
    implements CopyableBuilder<Builder, TransferListenerFailedContext> {
        private TransferListenerContext transferContext;
        private Throwable exception;

        private Builder() {
        }

        private Builder(TransferListenerFailedContext failedContext) {
            this.exception = failedContext.exception;
            this.transferContext = failedContext.transferContext;
        }

        public Builder exception(Throwable exception) {
            this.exception = exception;
            return this;
        }

        public Builder transferContext(TransferListenerContext transferContext) {
            this.transferContext = transferContext;
            return this;
        }

        public TransferListenerFailedContext build() {
            return new TransferListenerFailedContext(this);
        }
    }
}

