/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3.model;

import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPreviewApi;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.transfer.s3.model.TransferDirectoryRequest;
import software.amazon.awssdk.transfer.s3.model.UploadFileRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
@SdkPreviewApi
public final class UploadDirectoryRequest
implements TransferDirectoryRequest,
ToCopyableBuilder<Builder, UploadDirectoryRequest> {
    private final Path source;
    private final String bucket;
    private final String s3Prefix;
    private final String s3Delimiter;
    private final Boolean followSymbolicLinks;
    private final Integer maxDepth;
    private final Consumer<UploadFileRequest.Builder> uploadFileRequestTransformer;

    public UploadDirectoryRequest(DefaultBuilder builder) {
        this.source = (Path)Validate.paramNotNull((Object)builder.source, (String)"source");
        this.bucket = (String)Validate.paramNotNull((Object)builder.bucket, (String)"bucket");
        this.s3Prefix = builder.s3Prefix;
        this.s3Delimiter = builder.s3Delimiter;
        this.followSymbolicLinks = builder.followSymbolicLinks;
        this.maxDepth = builder.maxDepth;
        this.uploadFileRequestTransformer = builder.uploadFileRequestTransformer;
    }

    public Path source() {
        return this.source;
    }

    public String bucket() {
        return this.bucket;
    }

    public Optional<String> s3Prefix() {
        return Optional.ofNullable(this.s3Prefix);
    }

    public Optional<String> s3Delimiter() {
        return Optional.ofNullable(this.s3Delimiter);
    }

    public Optional<Boolean> followSymbolicLinks() {
        return Optional.ofNullable(this.followSymbolicLinks);
    }

    public OptionalInt maxDepth() {
        return this.maxDepth == null ? OptionalInt.empty() : OptionalInt.of(this.maxDepth);
    }

    public Consumer<UploadFileRequest.Builder> uploadFileRequestTransformer() {
        return this.uploadFileRequestTransformer == null ? ignore -> {} : this.uploadFileRequestTransformer;
    }

    public static Builder builder() {
        return new DefaultBuilder();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return DefaultBuilder.class;
    }

    public Builder toBuilder() {
        return new DefaultBuilder(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UploadDirectoryRequest that = (UploadDirectoryRequest)o;
        if (!Objects.equals(this.source, that.source)) {
            return false;
        }
        if (!Objects.equals(this.bucket, that.bucket)) {
            return false;
        }
        if (!Objects.equals(this.s3Prefix, that.s3Prefix)) {
            return false;
        }
        if (!Objects.equals(this.followSymbolicLinks, that.followSymbolicLinks)) {
            return false;
        }
        if (!Objects.equals(this.maxDepth, that.maxDepth)) {
            return false;
        }
        if (!Objects.equals(this.uploadFileRequestTransformer, that.uploadFileRequestTransformer)) {
            return false;
        }
        return Objects.equals(this.s3Delimiter, that.s3Delimiter);
    }

    public int hashCode() {
        int result = this.source != null ? this.source.hashCode() : 0;
        result = 31 * result + (this.bucket != null ? this.bucket.hashCode() : 0);
        result = 31 * result + (this.s3Prefix != null ? this.s3Prefix.hashCode() : 0);
        result = 31 * result + (this.s3Delimiter != null ? this.s3Delimiter.hashCode() : 0);
        result = 31 * result + (this.followSymbolicLinks != null ? this.followSymbolicLinks.hashCode() : 0);
        result = 31 * result + (this.maxDepth != null ? this.maxDepth.hashCode() : 0);
        result = 31 * result + (this.uploadFileRequestTransformer != null ? this.uploadFileRequestTransformer.hashCode() : 0);
        return result;
    }

    public String toString() {
        return ToString.builder((String)"UploadDirectoryRequest").add("source", (Object)this.source).add("bucket", (Object)this.bucket).add("s3Prefix", (Object)this.s3Prefix).add("s3Delimiter", (Object)this.s3Delimiter).add("followSymbolicLinks", (Object)this.followSymbolicLinks).add("maxDepth", (Object)this.maxDepth).add("uploadFileRequestTransformer", this.uploadFileRequestTransformer).build();
    }

    private static final class DefaultBuilder
    implements Builder {
        private Path source;
        private String bucket;
        private String s3Prefix;
        private String s3Delimiter;
        private Boolean followSymbolicLinks;
        private Integer maxDepth;
        private Consumer<UploadFileRequest.Builder> uploadFileRequestTransformer;

        private DefaultBuilder() {
        }

        private DefaultBuilder(UploadDirectoryRequest request) {
            this.source = request.source;
            this.bucket = request.bucket;
            this.s3Prefix = request.s3Prefix;
            this.s3Delimiter = request.s3Delimiter;
            this.followSymbolicLinks = request.followSymbolicLinks;
            this.maxDepth = request.maxDepth;
            this.uploadFileRequestTransformer = request.uploadFileRequestTransformer;
        }

        @Override
        public Builder source(Path source) {
            this.source = source;
            return this;
        }

        public void setSource(Path source) {
            this.source(source);
        }

        public Path getSource() {
            return this.source;
        }

        @Override
        public Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public void setBucket(String bucket) {
            this.bucket(bucket);
        }

        public String getBucket() {
            return this.bucket;
        }

        @Override
        public Builder s3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
            return this;
        }

        public void setS3Prefix(String s3Prefix) {
            this.s3Prefix(s3Prefix);
        }

        public String getS3Prefix() {
            return this.s3Prefix;
        }

        @Override
        public Builder s3Delimiter(String s3Delimiter) {
            this.s3Delimiter = s3Delimiter;
            return this;
        }

        public void setS3Delimiter(String s3Delimiter) {
            this.s3Delimiter(s3Delimiter);
        }

        public String getS3Delimiter() {
            return this.s3Delimiter;
        }

        @Override
        public Builder followSymbolicLinks(Boolean followSymbolicLinks) {
            this.followSymbolicLinks = followSymbolicLinks;
            return this;
        }

        public void setFollowSymbolicLinks(Boolean followSymbolicLinks) {
            this.followSymbolicLinks(followSymbolicLinks);
        }

        public Boolean getFollowSymbolicLinks() {
            return this.followSymbolicLinks;
        }

        @Override
        public Builder maxDepth(Integer maxDepth) {
            this.maxDepth = maxDepth;
            return this;
        }

        public void setMaxDepth(Integer maxDepth) {
            this.maxDepth(maxDepth);
        }

        public Integer getMaxDepth() {
            return this.maxDepth;
        }

        @Override
        public Builder uploadFileRequestTransformer(Consumer<UploadFileRequest.Builder> uploadFileRequestTransformer) {
            this.uploadFileRequestTransformer = uploadFileRequestTransformer;
            return this;
        }

        public Consumer<UploadFileRequest.Builder> getUploadFileRequestTransformer() {
            return this.uploadFileRequestTransformer;
        }

        public void setUploadFileRequestTransformer(Consumer<UploadFileRequest.Builder> uploadFileRequestTransformer) {
            this.uploadFileRequestTransformer = uploadFileRequestTransformer;
        }

        @Override
        public UploadDirectoryRequest build() {
            return new UploadDirectoryRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UploadDirectoryRequest> {
        public Builder source(Path var1);

        public Builder bucket(String var1);

        public Builder s3Prefix(String var1);

        public Builder s3Delimiter(String var1);

        public Builder followSymbolicLinks(Boolean var1);

        public Builder maxDepth(Integer var1);

        public Builder uploadFileRequestTransformer(Consumer<UploadFileRequest.Builder> var1);

        public UploadDirectoryRequest build();
    }
}

