/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkPreviewApi;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.transfer.s3.model.TransferObjectRequest;
import software.amazon.awssdk.transfer.s3.progress.TransferListener;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
@SdkPreviewApi
public final class UploadRequest
implements TransferObjectRequest,
ToCopyableBuilder<Builder, UploadRequest> {
    private final PutObjectRequest putObjectRequest;
    private final AsyncRequestBody requestBody;
    private final List<TransferListener> listeners;

    private UploadRequest(DefaultBuilder builder) {
        this.putObjectRequest = (PutObjectRequest)Validate.paramNotNull((Object)builder.putObjectRequest, (String)"putObjectRequest");
        this.requestBody = (AsyncRequestBody)Validate.paramNotNull((Object)builder.requestBody, (String)"requestBody");
        this.listeners = builder.listeners;
    }

    public PutObjectRequest putObjectRequest() {
        return this.putObjectRequest;
    }

    public AsyncRequestBody requestBody() {
        return this.requestBody;
    }

    @Override
    public List<TransferListener> transferListeners() {
        return this.listeners;
    }

    public static Builder builder() {
        return new DefaultBuilder();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return DefaultBuilder.class;
    }

    public Builder toBuilder() {
        return new DefaultBuilder(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UploadRequest that = (UploadRequest)o;
        if (!Objects.equals(this.putObjectRequest, that.putObjectRequest)) {
            return false;
        }
        if (!Objects.equals(this.requestBody, that.requestBody)) {
            return false;
        }
        return Objects.equals(this.listeners, that.listeners);
    }

    public int hashCode() {
        int result = this.putObjectRequest != null ? this.putObjectRequest.hashCode() : 0;
        result = 31 * result + (this.requestBody != null ? this.requestBody.hashCode() : 0);
        result = 31 * result + (this.listeners != null ? this.listeners.hashCode() : 0);
        return result;
    }

    public String toString() {
        return ToString.builder((String)"UploadRequest").add("putObjectRequest", (Object)this.putObjectRequest).add("requestBody", (Object)this.requestBody).add("configuration", this.listeners).build();
    }

    private static class DefaultBuilder
    implements Builder {
        private PutObjectRequest putObjectRequest;
        private AsyncRequestBody requestBody;
        private List<TransferListener> listeners;

        private DefaultBuilder() {
        }

        private DefaultBuilder(UploadRequest uploadRequest) {
            this.putObjectRequest = uploadRequest.putObjectRequest;
            this.requestBody = uploadRequest.requestBody;
            this.listeners = uploadRequest.listeners;
        }

        @Override
        public Builder requestBody(AsyncRequestBody requestBody) {
            this.requestBody = (AsyncRequestBody)Validate.paramNotNull((Object)requestBody, (String)"requestBody");
            return this;
        }

        public AsyncRequestBody getRequestBody() {
            return this.requestBody;
        }

        public void setRequestBody(AsyncRequestBody requestBody) {
            this.requestBody(requestBody);
        }

        @Override
        public Builder putObjectRequest(PutObjectRequest putObjectRequest) {
            this.putObjectRequest = putObjectRequest;
            return this;
        }

        public PutObjectRequest getPutObjectRequest() {
            return this.putObjectRequest;
        }

        public void setPutObjectRequest(PutObjectRequest putObjectRequest) {
            this.putObjectRequest(putObjectRequest);
        }

        @Override
        public Builder transferListeners(Collection<TransferListener> transferListeners) {
            this.listeners = transferListeners != null ? new ArrayList<TransferListener>(transferListeners) : null;
            return this;
        }

        @Override
        public Builder addTransferListener(TransferListener transferListener) {
            if (this.listeners == null) {
                this.listeners = new ArrayList<TransferListener>();
            }
            this.listeners.add(transferListener);
            return this;
        }

        public List<TransferListener> getListeners() {
            return this.listeners;
        }

        public void setListeners(Collection<TransferListener> listeners) {
            this.transferListeners(listeners);
        }

        @Override
        public UploadRequest build() {
            return new UploadRequest(this);
        }
    }

    @SdkPublicApi
    @NotThreadSafe
    public static interface Builder
    extends CopyableBuilder<Builder, UploadRequest> {
        public Builder requestBody(AsyncRequestBody var1);

        public Builder putObjectRequest(PutObjectRequest var1);

        default public Builder putObjectRequest(Consumer<PutObjectRequest.Builder> putObjectRequestBuilder) {
            return this.putObjectRequest((PutObjectRequest)((PutObjectRequest.Builder)PutObjectRequest.builder().applyMutation(putObjectRequestBuilder)).build());
        }

        public Builder transferListeners(Collection<TransferListener> var1);

        public Builder addTransferListener(TransferListener var1);

        public UploadRequest build();
    }
}

