/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3.model;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkPreviewApi;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.transfer.s3.model.TransferObjectRequest;
import software.amazon.awssdk.transfer.s3.progress.TransferListener;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
@SdkPreviewApi
public final class UploadFileRequest
implements TransferObjectRequest,
ToCopyableBuilder<Builder, UploadFileRequest> {
    private final PutObjectRequest putObjectRequest;
    private final Path source;
    private final List<TransferListener> listeners;

    private UploadFileRequest(DefaultBuilder builder) {
        this.putObjectRequest = (PutObjectRequest)Validate.paramNotNull((Object)builder.putObjectRequest, (String)"putObjectRequest");
        this.source = (Path)Validate.paramNotNull((Object)builder.source, (String)"source");
        this.listeners = builder.listeners;
    }

    public PutObjectRequest putObjectRequest() {
        return this.putObjectRequest;
    }

    public Path source() {
        return this.source;
    }

    @Override
    public List<TransferListener> transferListeners() {
        return this.listeners;
    }

    public static Builder builder() {
        return new DefaultBuilder();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return DefaultBuilder.class;
    }

    public Builder toBuilder() {
        return new DefaultBuilder(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UploadFileRequest that = (UploadFileRequest)o;
        if (!Objects.equals(this.putObjectRequest, that.putObjectRequest)) {
            return false;
        }
        if (!Objects.equals(this.source, that.source)) {
            return false;
        }
        return Objects.equals(this.listeners, that.listeners);
    }

    public int hashCode() {
        int result = this.putObjectRequest != null ? this.putObjectRequest.hashCode() : 0;
        result = 31 * result + (this.source != null ? this.source.hashCode() : 0);
        result = 31 * result + (this.listeners != null ? this.listeners.hashCode() : 0);
        return result;
    }

    public String toString() {
        return ToString.builder((String)"UploadFileRequest").add("putObjectRequest", (Object)this.putObjectRequest).add("source", (Object)this.source).add("configuration", this.listeners).build();
    }

    private static class DefaultBuilder
    implements Builder {
        private PutObjectRequest putObjectRequest;
        private Path source;
        private List<TransferListener> listeners;

        private DefaultBuilder() {
        }

        private DefaultBuilder(UploadFileRequest uploadFileRequest) {
            this.source = uploadFileRequest.source;
            this.putObjectRequest = uploadFileRequest.putObjectRequest;
            this.listeners = uploadFileRequest.listeners;
        }

        @Override
        public Builder source(Path source) {
            this.source = (Path)Validate.paramNotNull((Object)source, (String)"source");
            return this;
        }

        public Path getSource() {
            return this.source;
        }

        public void setSource(Path source) {
            this.source(source);
        }

        @Override
        public Builder putObjectRequest(PutObjectRequest putObjectRequest) {
            this.putObjectRequest = putObjectRequest;
            return this;
        }

        public PutObjectRequest getPutObjectRequest() {
            return this.putObjectRequest;
        }

        public void setPutObjectRequest(PutObjectRequest putObjectRequest) {
            this.putObjectRequest(putObjectRequest);
        }

        @Override
        public Builder transferListeners(Collection<TransferListener> transferListeners) {
            this.listeners = transferListeners != null ? new ArrayList<TransferListener>(transferListeners) : null;
            return this;
        }

        @Override
        public Builder addTransferListener(TransferListener transferListener) {
            if (this.listeners == null) {
                this.listeners = new ArrayList<TransferListener>();
            }
            this.listeners.add(transferListener);
            return this;
        }

        public List<TransferListener> getListeners() {
            return this.listeners;
        }

        public void setListeners(Collection<TransferListener> listeners) {
            this.transferListeners(listeners);
        }

        public UploadFileRequest build() {
            return new UploadFileRequest(this);
        }
    }

    @SdkPublicApi
    @NotThreadSafe
    public static interface Builder
    extends CopyableBuilder<Builder, UploadFileRequest> {
        public Builder source(Path var1);

        default public Builder source(File source) {
            Validate.paramNotNull((Object)source, (String)"source");
            return this.source(source.toPath());
        }

        public Builder putObjectRequest(PutObjectRequest var1);

        default public Builder putObjectRequest(Consumer<PutObjectRequest.Builder> putObjectRequestBuilder) {
            return this.putObjectRequest((PutObjectRequest)((PutObjectRequest.Builder)PutObjectRequest.builder().applyMutation(putObjectRequestBuilder)).build());
        }

        public Builder transferListeners(Collection<TransferListener> var1);

        public Builder addTransferListener(TransferListener var1);
    }
}

