/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3.model;

import java.util.Objects;
import software.amazon.awssdk.annotations.SdkPreviewApi;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.transfer.s3.model.DownloadFileRequest;
import software.amazon.awssdk.transfer.s3.model.FailedObjectTransfer;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
@SdkPreviewApi
public final class FailedFileDownload
implements FailedObjectTransfer,
ToCopyableBuilder<Builder, FailedFileDownload> {
    private final DownloadFileRequest request;
    private final Throwable exception;

    private FailedFileDownload(DefaultBuilder builder) {
        this.exception = (Throwable)Validate.paramNotNull((Object)builder.exception, (String)"exception");
        this.request = (DownloadFileRequest)Validate.paramNotNull((Object)builder.request, (String)"request");
    }

    @Override
    public Throwable exception() {
        return this.exception;
    }

    @Override
    public DownloadFileRequest request() {
        return this.request;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FailedFileDownload that = (FailedFileDownload)o;
        if (!Objects.equals(this.request, that.request)) {
            return false;
        }
        return Objects.equals(this.exception, that.exception);
    }

    public int hashCode() {
        int result = this.request != null ? this.request.hashCode() : 0;
        result = 31 * result + (this.exception != null ? this.exception.hashCode() : 0);
        return result;
    }

    public String toString() {
        return ToString.builder((String)"FailedFileDownload").add("request", (Object)this.request).add("exception", (Object)this.exception).build();
    }

    public static Builder builder() {
        return new DefaultBuilder();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return DefaultBuilder.class;
    }

    public Builder toBuilder() {
        return new DefaultBuilder(this);
    }

    private static final class DefaultBuilder
    implements Builder {
        private DownloadFileRequest request;
        private Throwable exception;

        private DefaultBuilder(FailedFileDownload failedFileDownload) {
            this.request = failedFileDownload.request;
            this.exception = failedFileDownload.exception;
        }

        private DefaultBuilder() {
        }

        @Override
        public Builder exception(Throwable exception) {
            this.exception = exception;
            return this;
        }

        public void setException(Throwable exception) {
            this.exception(exception);
        }

        public Throwable getException() {
            return this.exception;
        }

        @Override
        public Builder request(DownloadFileRequest request) {
            this.request = request;
            return this;
        }

        public void setRequest(DownloadFileRequest request) {
            this.request(request);
        }

        public DownloadFileRequest getRequest() {
            return this.request;
        }

        public FailedFileDownload build() {
            return new FailedFileDownload(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, FailedFileDownload> {
        public Builder exception(Throwable var1);

        public Builder request(DownloadFileRequest var1);
    }
}

