/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3.internal.utils;

import java.io.File;
import java.nio.file.Path;
import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.FileTransformerConfiguration;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import software.amazon.awssdk.transfer.s3.DownloadFileRequest;
import software.amazon.awssdk.transfer.s3.ResumableFileDownload;
import software.amazon.awssdk.transfer.s3.S3TransferManager;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.Pair;

@SdkInternalApi
public final class ResumableRequestConverter {
    private static final Logger log = Logger.loggerFor(S3TransferManager.class);

    private ResumableRequestConverter() {
    }

    public static Pair<DownloadFileRequest, AsyncResponseTransformer<GetObjectResponse, GetObjectResponse>> toDownloadFileRequestAndTransformer(ResumableFileDownload resumableFileDownload, HeadObjectResponse headObjectResponse, DownloadFileRequest originalDownloadRequest) {
        boolean shouldAppend;
        DownloadFileRequest newDownloadFileRequest;
        GetObjectRequest getObjectRequest = originalDownloadRequest.getObjectRequest();
        Instant lastModified = resumableFileDownload.s3ObjectLastModified().orElse(null);
        Instant fileLastModified = Instant.ofEpochMilli(resumableFileDownload.downloadFileRequest().destination().toFile().lastModified());
        boolean s3ObjectNotModified = headObjectResponse.lastModified().equals(lastModified);
        boolean fileNotModified = ResumableRequestConverter.fileNotModified(resumableFileDownload, originalDownloadRequest.destination().toFile(), fileLastModified);
        if (fileNotModified && s3ObjectNotModified) {
            newDownloadFileRequest = ResumableRequestConverter.resumedDownloadFileRequest(resumableFileDownload, originalDownloadRequest, getObjectRequest, headObjectResponse);
            shouldAppend = true;
        } else {
            ResumableRequestConverter.logIfNeeded(originalDownloadRequest, getObjectRequest, fileNotModified, s3ObjectNotModified);
            shouldAppend = false;
            newDownloadFileRequest = ResumableRequestConverter.newDownloadFileRequest(originalDownloadRequest, getObjectRequest, headObjectResponse);
        }
        AsyncResponseTransformer<GetObjectResponse, GetObjectResponse> responseTransformer = ResumableRequestConverter.fileAsyncResponseTransformer(newDownloadFileRequest, shouldAppend);
        return Pair.of((Object)newDownloadFileRequest, responseTransformer);
    }

    private static boolean fileNotModified(ResumableFileDownload resumableFileDownload, File destination, Instant fileLastModified) {
        return resumableFileDownload.fileLastModified().equals(fileLastModified) && resumableFileDownload.bytesTransferred() == destination.length();
    }

    private static AsyncResponseTransformer<GetObjectResponse, GetObjectResponse> fileAsyncResponseTransformer(DownloadFileRequest newDownloadFileRequest, boolean shouldAppend) {
        FileTransformerConfiguration fileTransformerConfiguration = shouldAppend ? FileTransformerConfiguration.defaultCreateOrAppend() : FileTransformerConfiguration.defaultCreateOrReplaceExisting();
        return AsyncResponseTransformer.toFile((Path)newDownloadFileRequest.destination(), (FileTransformerConfiguration)fileTransformerConfiguration);
    }

    private static void logIfNeeded(DownloadFileRequest downloadRequest, GetObjectRequest getObjectRequest, boolean fileNotModified, boolean s3ObjectNotModified) {
        if (log.logger().isDebugEnabled()) {
            if (!s3ObjectNotModified) {
                log.debug(() -> String.format("The requested object in bucket (%s) with key (%s) has been modified on Amazon S3 since the last pause. The SDK will download the S3 object from the beginning", getObjectRequest.bucket(), getObjectRequest.key()));
            }
            if (!fileNotModified) {
                log.debug(() -> String.format("The file (%s) has been modified since the last pause. The SDK will download the requested object in bucket (%s) with key (%s) from the beginning.", downloadRequest.destination(), getObjectRequest.bucket(), getObjectRequest.key()));
            }
        }
    }

    private static DownloadFileRequest resumedDownloadFileRequest(ResumableFileDownload resumableFileDownload, DownloadFileRequest downloadRequest, GetObjectRequest getObjectRequest, HeadObjectResponse headObjectResponse) {
        long bytesTransferred = resumableFileDownload.bytesTransferred();
        GetObjectRequest newGetObjectRequest = (GetObjectRequest)getObjectRequest.toBuilder().ifUnmodifiedSince(headObjectResponse.lastModified()).range("bytes=" + bytesTransferred + "-" + headObjectResponse.contentLength()).build();
        DownloadFileRequest newDownloadFileRequest = (DownloadFileRequest)downloadRequest.toBuilder().getObjectRequest(newGetObjectRequest).build();
        return newDownloadFileRequest;
    }

    private static DownloadFileRequest newDownloadFileRequest(DownloadFileRequest originalDownloadRequest, GetObjectRequest getObjectRequest, HeadObjectResponse headObjectResponse) {
        return (DownloadFileRequest)originalDownloadRequest.toBuilder().getObjectRequest((GetObjectRequest)getObjectRequest.toBuilder().ifUnmodifiedSince(headObjectResponse.lastModified()).build()).build();
    }
}

