/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3.internal;

import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.SdkTestInternalApi;
import software.amazon.awssdk.arns.Arn;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.core.client.config.ClientAsyncConfiguration;
import software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption;
import software.amazon.awssdk.services.s3.internal.resource.S3AccessPointResource;
import software.amazon.awssdk.services.s3.internal.resource.S3ArnConverter;
import software.amazon.awssdk.services.s3.internal.resource.S3Resource;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;
import software.amazon.awssdk.transfer.s3.CompletedDownload;
import software.amazon.awssdk.transfer.s3.CompletedFileDownload;
import software.amazon.awssdk.transfer.s3.CompletedFileUpload;
import software.amazon.awssdk.transfer.s3.CompletedUpload;
import software.amazon.awssdk.transfer.s3.DirectoryUpload;
import software.amazon.awssdk.transfer.s3.Download;
import software.amazon.awssdk.transfer.s3.DownloadFileRequest;
import software.amazon.awssdk.transfer.s3.DownloadRequest;
import software.amazon.awssdk.transfer.s3.FileDownload;
import software.amazon.awssdk.transfer.s3.FileUpload;
import software.amazon.awssdk.transfer.s3.S3ClientConfiguration;
import software.amazon.awssdk.transfer.s3.S3TransferManager;
import software.amazon.awssdk.transfer.s3.S3TransferManagerOverrideConfiguration;
import software.amazon.awssdk.transfer.s3.Upload;
import software.amazon.awssdk.transfer.s3.UploadDirectoryRequest;
import software.amazon.awssdk.transfer.s3.UploadFileRequest;
import software.amazon.awssdk.transfer.s3.UploadRequest;
import software.amazon.awssdk.transfer.s3.internal.DefaultDirectoryUpload;
import software.amazon.awssdk.transfer.s3.internal.DefaultDownload;
import software.amazon.awssdk.transfer.s3.internal.DefaultFileDownload;
import software.amazon.awssdk.transfer.s3.internal.DefaultFileUpload;
import software.amazon.awssdk.transfer.s3.internal.DefaultUpload;
import software.amazon.awssdk.transfer.s3.internal.S3CrtAsyncClient;
import software.amazon.awssdk.transfer.s3.internal.TransferConfigurationOption;
import software.amazon.awssdk.transfer.s3.internal.TransferManagerConfiguration;
import software.amazon.awssdk.transfer.s3.internal.UploadDirectoryHelper;
import software.amazon.awssdk.transfer.s3.internal.progress.TransferProgressUpdater;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultS3TransferManager
implements S3TransferManager {
    private final S3CrtAsyncClient s3CrtAsyncClient;
    private final TransferManagerConfiguration transferConfiguration;
    private final UploadDirectoryHelper uploadDirectoryManager;

    public DefaultS3TransferManager(DefaultBuilder tmBuilder) {
        this.transferConfiguration = this.resolveTransferManagerConfiguration(tmBuilder);
        this.s3CrtAsyncClient = this.initializeS3CrtClient(tmBuilder);
        this.uploadDirectoryManager = new UploadDirectoryHelper(this.transferConfiguration, this::uploadFile);
    }

    @SdkTestInternalApi
    DefaultS3TransferManager(S3CrtAsyncClient s3CrtAsyncClient, UploadDirectoryHelper uploadDirectoryManager, TransferManagerConfiguration configuration) {
        this.s3CrtAsyncClient = s3CrtAsyncClient;
        this.transferConfiguration = configuration;
        this.uploadDirectoryManager = uploadDirectoryManager;
    }

    private TransferManagerConfiguration resolveTransferManagerConfiguration(DefaultBuilder tmBuilder) {
        TransferManagerConfiguration.Builder transferConfigBuilder = TransferManagerConfiguration.builder();
        tmBuilder.transferManagerConfiguration.uploadDirectoryConfiguration().ifPresent(transferConfigBuilder::uploadDirectoryConfiguration);
        tmBuilder.transferManagerConfiguration.executor().ifPresent(transferConfigBuilder::executor);
        return transferConfigBuilder.build();
    }

    private S3CrtAsyncClient initializeS3CrtClient(DefaultBuilder tmBuilder) {
        S3CrtAsyncClient.S3CrtAsyncClientBuilder clientBuilder = S3CrtAsyncClient.builder();
        tmBuilder.s3ClientConfiguration.credentialsProvider().ifPresent(clientBuilder::credentialsProvider);
        tmBuilder.s3ClientConfiguration.maxConcurrency().ifPresent(clientBuilder::maxConcurrency);
        tmBuilder.s3ClientConfiguration.minimumPartSizeInBytes().ifPresent(clientBuilder::minimumPartSizeInBytes);
        tmBuilder.s3ClientConfiguration.region().ifPresent(clientBuilder::region);
        tmBuilder.s3ClientConfiguration.targetThroughputInGbps().ifPresent(clientBuilder::targetThroughputInGbps);
        ClientAsyncConfiguration clientAsyncConfiguration = (ClientAsyncConfiguration)ClientAsyncConfiguration.builder().advancedOption(SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR, (Object)this.transferConfiguration.option(TransferConfigurationOption.EXECUTOR)).build();
        clientBuilder.asyncConfiguration(clientAsyncConfiguration);
        return clientBuilder.build();
    }

    @Override
    public Upload upload(UploadRequest uploadRequest) {
        Validate.paramNotNull((Object)uploadRequest, (String)"uploadRequest");
        AsyncRequestBody requestBody = uploadRequest.requestBody();
        CompletableFuture<CompletedUpload> uploadFuture = new CompletableFuture<CompletedUpload>();
        TransferProgressUpdater progressUpdater = new TransferProgressUpdater(uploadRequest, requestBody);
        progressUpdater.transferInitiated();
        requestBody = progressUpdater.wrapRequestBody(requestBody);
        progressUpdater.registerCompletion(uploadFuture);
        try {
            DefaultS3TransferManager.assertNotUnsupportedArn(uploadRequest.putObjectRequest().bucket(), "upload");
            CompletableFuture putObjFuture = this.s3CrtAsyncClient.putObject(uploadRequest.putObjectRequest(), requestBody);
            CompletableFutureUtils.forwardExceptionTo(uploadFuture, (CompletableFuture)putObjFuture);
            CompletableFutureUtils.forwardTransformedResultTo((CompletableFuture)putObjFuture, uploadFuture, r -> CompletedUpload.builder().response((PutObjectResponse)r).build());
        }
        catch (Throwable throwable) {
            uploadFuture.completeExceptionally(throwable);
        }
        return new DefaultUpload(uploadFuture, progressUpdater.progress());
    }

    @Override
    public FileUpload uploadFile(UploadFileRequest uploadFileRequest) {
        Validate.paramNotNull((Object)uploadFileRequest, (String)"uploadFileRequest");
        AsyncRequestBody requestBody = AsyncRequestBody.fromFile((Path)uploadFileRequest.source());
        CompletableFuture<CompletedFileUpload> uploadFuture = new CompletableFuture<CompletedFileUpload>();
        TransferProgressUpdater progressUpdater = new TransferProgressUpdater(uploadFileRequest, requestBody);
        progressUpdater.transferInitiated();
        requestBody = progressUpdater.wrapRequestBody(requestBody);
        progressUpdater.registerCompletion(uploadFuture);
        try {
            DefaultS3TransferManager.assertNotUnsupportedArn(uploadFileRequest.putObjectRequest().bucket(), "upload");
            CompletableFuture putObjFuture = this.s3CrtAsyncClient.putObject(uploadFileRequest.putObjectRequest(), requestBody);
            CompletableFutureUtils.forwardExceptionTo(uploadFuture, (CompletableFuture)putObjFuture);
            CompletableFutureUtils.forwardTransformedResultTo((CompletableFuture)putObjFuture, uploadFuture, r -> CompletedFileUpload.builder().response((PutObjectResponse)r).build());
        }
        catch (Throwable throwable) {
            uploadFuture.completeExceptionally(throwable);
        }
        return new DefaultFileUpload(uploadFuture, progressUpdater.progress());
    }

    @Override
    public DirectoryUpload uploadDirectory(UploadDirectoryRequest uploadDirectoryRequest) {
        Validate.paramNotNull((Object)uploadDirectoryRequest, (String)"uploadDirectoryRequest");
        try {
            DefaultS3TransferManager.assertNotUnsupportedArn(uploadDirectoryRequest.bucket(), "uploadDirectory");
            return this.uploadDirectoryManager.uploadDirectory(uploadDirectoryRequest);
        }
        catch (Throwable throwable) {
            return new DefaultDirectoryUpload(CompletableFutureUtils.failedFuture((Throwable)throwable));
        }
    }

    @Override
    public <ResultT> Download<ResultT> download(DownloadRequest<ResultT> downloadRequest) {
        Validate.paramNotNull(downloadRequest, (String)"downloadRequest");
        AsyncResponseTransformer<GetObjectResponse, ResultT> responseTransformer = downloadRequest.responseTransformer();
        CompletableFuture downloadFuture = new CompletableFuture();
        TransferProgressUpdater progressUpdater = new TransferProgressUpdater(downloadRequest, null);
        progressUpdater.transferInitiated();
        responseTransformer = progressUpdater.wrapResponseTransformer(responseTransformer);
        progressUpdater.registerCompletion(downloadFuture);
        try {
            DefaultS3TransferManager.assertNotUnsupportedArn(downloadRequest.getObjectRequest().bucket(), "download");
            CompletableFuture getObjectFuture = this.s3CrtAsyncClient.getObject(downloadRequest.getObjectRequest(), responseTransformer);
            CompletableFutureUtils.forwardExceptionTo(downloadFuture, (CompletableFuture)getObjectFuture);
            CompletableFutureUtils.forwardTransformedResultTo((CompletableFuture)getObjectFuture, downloadFuture, r -> (CompletedDownload)CompletedDownload.builder().result(r).build());
        }
        catch (Throwable throwable) {
            downloadFuture.completeExceptionally(throwable);
        }
        return new DefaultDownload(downloadFuture, progressUpdater.progress());
    }

    @Override
    public FileDownload downloadFile(DownloadFileRequest downloadRequest) {
        Validate.paramNotNull((Object)downloadRequest, (String)"downloadFileRequest");
        AsyncResponseTransformer responseTransformer = AsyncResponseTransformer.toFile((Path)downloadRequest.destination());
        CompletableFuture<CompletedFileDownload> downloadFuture = new CompletableFuture<CompletedFileDownload>();
        TransferProgressUpdater progressUpdater = new TransferProgressUpdater(downloadRequest, null);
        progressUpdater.transferInitiated();
        responseTransformer = progressUpdater.wrapResponseTransformer(responseTransformer);
        progressUpdater.registerCompletion(downloadFuture);
        try {
            DefaultS3TransferManager.assertNotUnsupportedArn(downloadRequest.getObjectRequest().bucket(), "download");
            CompletableFuture getObjectFuture = this.s3CrtAsyncClient.getObject(downloadRequest.getObjectRequest(), responseTransformer);
            CompletableFutureUtils.forwardExceptionTo(downloadFuture, (CompletableFuture)getObjectFuture);
            CompletableFutureUtils.forwardTransformedResultTo((CompletableFuture)getObjectFuture, downloadFuture, r -> CompletedFileDownload.builder().response((GetObjectResponse)r).build());
        }
        catch (Throwable throwable) {
            downloadFuture.completeExceptionally(throwable);
        }
        return new DefaultFileDownload(downloadFuture, progressUpdater.progress());
    }

    public void close() {
        this.s3CrtAsyncClient.close();
        this.transferConfiguration.close();
    }

    public static S3TransferManager.Builder builder() {
        return new DefaultBuilder();
    }

    private static void assertNotUnsupportedArn(String bucket, String operation) {
        if (!bucket.startsWith("arn:")) {
            return;
        }
        if (DefaultS3TransferManager.isObjectLambdaArn(bucket)) {
            String error = String.format("%s does not support S3 Object Lambda resources", operation);
            throw new IllegalArgumentException(error);
        }
        Arn arn = Arn.fromString((String)bucket);
        if (DefaultS3TransferManager.isMrapArn(arn)) {
            String error = String.format("%s does not support S3 multi-region access point ARN", operation);
            throw new IllegalArgumentException(error);
        }
    }

    private static boolean isObjectLambdaArn(String arn) {
        return arn.contains(":s3-object-lambda");
    }

    private static boolean isMrapArn(Arn arn) {
        S3Resource s3Resource = S3ArnConverter.create().convertArn(arn);
        S3AccessPointResource s3EndpointResource = (S3AccessPointResource)Validate.isInstanceOf(S3AccessPointResource.class, (Object)s3Resource, (String)"An ARN was passed as a bucket parameter to an S3 operation, however it does not appear to be a valid S3 access point ARN.", (Object[])new Object[0]);
        return !s3EndpointResource.region().isPresent();
    }

    private static class DefaultBuilder
    implements S3TransferManager.Builder {
        private S3ClientConfiguration s3ClientConfiguration = (S3ClientConfiguration)S3ClientConfiguration.builder().build();
        private S3TransferManagerOverrideConfiguration transferManagerConfiguration = (S3TransferManagerOverrideConfiguration)S3TransferManagerOverrideConfiguration.builder().build();

        private DefaultBuilder() {
        }

        @Override
        public S3TransferManager.Builder s3ClientConfiguration(S3ClientConfiguration configuration) {
            this.s3ClientConfiguration = configuration;
            return this;
        }

        @Override
        public S3TransferManager.Builder transferConfiguration(S3TransferManagerOverrideConfiguration transferManagerConfiguration) {
            this.transferManagerConfiguration = transferManagerConfiguration;
            return this;
        }

        @Override
        public S3TransferManager build() {
            return new DefaultS3TransferManager(this);
        }
    }
}

