/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3.internal;

import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.transfer.s3.UploadDirectoryOverrideConfiguration;
import software.amazon.awssdk.transfer.s3.UploadDirectoryRequest;
import software.amazon.awssdk.transfer.s3.internal.TransferConfigurationOption;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.ExecutorUtils;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class TransferManagerConfiguration
implements SdkAutoCloseable {
    private final AttributeMap options;

    private TransferManagerConfiguration(Builder builder) {
        UploadDirectoryOverrideConfiguration uploadDirectoryConfiguration = (UploadDirectoryOverrideConfiguration)Validate.paramNotNull((Object)builder.uploadDirectoryOverrideConfiguration, (String)"uploadDirectoryOverrideConfiguration");
        AttributeMap.Builder standardOptions = AttributeMap.builder();
        standardOptions.put(TransferConfigurationOption.UPLOAD_DIRECTORY_FOLLOW_SYMBOLIC_LINKS, uploadDirectoryConfiguration.followSymbolicLinks().orElse(null));
        standardOptions.put(TransferConfigurationOption.UPLOAD_DIRECTORY_MAX_DEPTH, uploadDirectoryConfiguration.maxDepth().orElse(null));
        standardOptions.put(TransferConfigurationOption.UPLOAD_DIRECTORY_RECURSIVE, uploadDirectoryConfiguration.recursive().orElse(null));
        this.finalizeExecutor(builder, standardOptions);
        this.options = standardOptions.build().merge(TransferConfigurationOption.TRANSFER_MANAGER_DEFAULTS);
    }

    private void finalizeExecutor(Builder builder, AttributeMap.Builder standardOptions) {
        if (builder.executor != null) {
            standardOptions.put(TransferConfigurationOption.EXECUTOR, (Object)ExecutorUtils.unmanagedExecutor((Executor)builder.executor));
        } else {
            standardOptions.put(TransferConfigurationOption.EXECUTOR, (Object)this.defaultExecutor());
        }
    }

    public <T> T option(TransferConfigurationOption<T> option) {
        return (T)this.options.get(option);
    }

    public boolean resolveUploadDirectoryRecursive(UploadDirectoryRequest request) {
        return (Boolean)request.overrideConfiguration().flatMap(UploadDirectoryOverrideConfiguration::recursive).orElse(this.options.get(TransferConfigurationOption.UPLOAD_DIRECTORY_RECURSIVE));
    }

    public boolean resolveUploadDirectoryFollowSymbolicLinks(UploadDirectoryRequest request) {
        return (Boolean)request.overrideConfiguration().flatMap(UploadDirectoryOverrideConfiguration::followSymbolicLinks).orElse(this.options.get(TransferConfigurationOption.UPLOAD_DIRECTORY_FOLLOW_SYMBOLIC_LINKS));
    }

    public int resolveUploadDirectoryMaxDepth(UploadDirectoryRequest request) {
        return (Integer)request.overrideConfiguration().flatMap(UploadDirectoryOverrideConfiguration::maxDepth).orElse(this.options.get(TransferConfigurationOption.UPLOAD_DIRECTORY_MAX_DEPTH));
    }

    public void close() {
        this.options.close();
    }

    private Executor defaultExecutor() {
        int maxPoolSize = 100;
        ThreadPoolExecutor executor = new ThreadPoolExecutor(0, maxPoolSize, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1000), new ThreadFactoryBuilder().threadNamePrefix("s3-transfer-manager").build());
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private UploadDirectoryOverrideConfiguration uploadDirectoryOverrideConfiguration = UploadDirectoryOverrideConfiguration.builder().build();
        private Executor executor;

        public Builder uploadDirectoryConfiguration(UploadDirectoryOverrideConfiguration configuration) {
            this.uploadDirectoryOverrideConfiguration = configuration;
            return this;
        }

        public Builder executor(Executor executor) {
            this.executor = executor;
            return this;
        }

        public TransferManagerConfiguration build() {
            return new TransferManagerConfiguration(this);
        }
    }
}

